/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class Logic40 {
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic40());
    }

    public static void run(Player player) {
        active = true;
    }

    private static boolean isNight(ServerLevel level) {
        long time = level.getDayTime() % 24000L;
        return time >= 13000L && time < 23000L;
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (Logic40.isNight(level)) {
            event.setCanceled(true);
            if (!player.level().isClientSide()) {
                player.displayClientMessage((Component)Component.literal((String)"\u041d\u043e\u0447\u044c\u044e \u043d\u0435\u043b\u044c\u0437\u044f \u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0431\u043b\u043e\u043a\u0438, \u0442\u043e\u043b\u044c\u043a\u043e \u043b\u043e\u043c\u0430\u0442\u044c!"), true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        ItemStack held;
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        if (!(event.getTarget() instanceof LivingEntity)) {
            return;
        }
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (Logic40.isNight(level2) && !(held = player.getItemInHand(InteractionHand.MAIN_HAND)).isEmpty()) {
            event.setCanceled(true);
            if (!player.level().isClientSide()) {
                player.displayClientMessage((Component)Component.literal((String)"\u041d\u043e\u0447\u044c\u044e \u043d\u0435\u043b\u044c\u0437\u044f \u0431\u0438\u0442\u044c \u043c\u043e\u0431\u043e\u0432 \u043e\u0440\u0443\u0436\u0438\u0435\u043c/\u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430\u043c\u0438. \u0411\u0435\u0439\u0442\u0435 \u0440\u0443\u043a\u0430\u043c\u0438 \u0438\u043b\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043b\u0443\u043a."), true);
            }
        }
    }
}

