/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class Logic41 {
    private static boolean registered = false;
    private static boolean active = true;
    private static final Map<ResourceKey<Level>, Boolean> WAS_NIGHT = new HashMap<ResourceKey<Level>, Boolean>();

    public static void init() {
        if (registered) {
            return;
        }
        registered = true;
        NeoForge.EVENT_BUS.register((Object)new Logic41());
    }

    public static void run(ServerPlayer player) {
        active = true;
    }

    @SubscribeEvent
    public void onLevelTick(LevelTickEvent.Post event) {
        if (!active) {
            return;
        }
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        ResourceKey dim = level2.dimension();
        long timeOfDay = level2.getDayTime() % 24000L;
        boolean isNight = timeOfDay >= 13000L && timeOfDay < 23000L;
        boolean wasNight = WAS_NIGHT.getOrDefault(dim, Boolean.FALSE);
        WAS_NIGHT.put((ResourceKey<Level>)dim, isNight);
        if (!wasNight && isNight) {
            if (level2.getDifficulty() == Difficulty.PEACEFUL) {
                return;
            }
            RandomSource rng = level2.getRandom();
            if (rng.nextFloat() <= 0.1f) {
                Logic41.spawnWardenNearRandomPlayer(level2, rng);
            }
        }
    }

    private static void spawnWardenNearRandomPlayer(ServerLevel level, RandomSource rng) {
        List players = level.players();
        if (players.isEmpty()) {
            return;
        }
        ServerPlayer target = (ServerPlayer)players.get(rng.nextInt(players.size()));
        for (int attempt = 0; attempt < 8; ++attempt) {
            int dx = rng.nextInt(33) - 16;
            int dz = rng.nextInt(33) - 16;
            BlockPos base = target.blockPosition().offset(dx, 0, dz);
            int x = base.getX();
            int z = base.getZ();
            int y = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
            BlockPos pos = new BlockPos(x, y, z);
            Warden warden = new Warden(EntityType.WARDEN, (Level)level);
            if (warden == null) continue;
            warden.setYRot(rng.nextFloat() * 360.0f);
            warden.setPos((double)x + 0.5, (double)y, (double)z + 0.5);
            if (!level.addFreshEntity((Entity)warden)) continue;
            if (warden.distanceToSqr((Entity)target) < 9.0) {
                warden.discard();
                continue;
            }
            return;
        }
    }
}

