/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

public class Logic44 {
    private static boolean registered = false;
    private static boolean active = false;

    public static void init() {
        if (registered) {
            return;
        }
        registered = true;
        NeoForge.EVENT_BUS.register((Object)new Logic44());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.level().isClientSide()) {
            return;
        }
        if (!(entity instanceof Skeleton || entity instanceof Zombie || entity instanceof Villager || entity instanceof IronGolem)) {
            return;
        }
        ServerLevel level = (ServerLevel)entity.level();
        RandomSource rand = level.getRandom();
        if (rand.nextFloat() > 0.1f) {
            return;
        }
        int count = 1 + rand.nextInt(2);
        double baseX = entity.getX();
        double baseY = entity.getY();
        double baseZ = entity.getZ();
        for (int i = 0; i < count; ++i) {
            double dx = baseX + (rand.nextDouble() - 0.5) * 4.0;
            double dy = baseY + rand.nextDouble() * 1.5;
            double dz = baseZ + (rand.nextDouble() - 0.5) * 4.0;
            Vex vex = new Vex(EntityType.VEX, (Level)level);
            if (vex == null) continue;
            vex.setPos(dx, dy, dz);
            vex.setYRot(rand.nextFloat() * 360.0f);
            vex.setXRot(0.0f);
            level.addFreshEntity((Entity)vex);
        }
    }
}

