/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

public class Logic47 {
    private static boolean registered = false;
    private static boolean active = false;

    public static void init() {
        if (registered) {
            return;
        }
        registered = true;
        NeoForge.EVENT_BUS.register((Object)new Logic47());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Vindicator)) {
            return;
        }
        Vindicator vindicator = (Vindicator)entity;
        if (event.getLevel().isClientSide()) {
            return;
        }
        CompoundTag tag = vindicator.getPersistentData();
        if (tag.getBoolean("logic47_bed_goal_added").orElse(false).booleanValue()) {
            return;
        }
        tag.putBoolean("logic47_bed_goal_added", true);
        vindicator.goalSelector.addGoal(1, (Goal)new SeekAndBreakBedGoal(vindicator));
    }

    private static class SeekAndBreakBedGoal
    extends Goal {
        private final Vindicator mob;
        private BlockPos targetBed;
        private int cooldown;
        private static final int SEARCH_RADIUS = 50;
        private static final int RECHECK_TICKS = 40;

        SeekAndBreakBedGoal(Vindicator mob) {
            this.mob = mob;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (this.mob.isRemoved() || this.mob.isDeadOrDying()) {
                return false;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            if (this.targetBed != null && this.isBed((LevelAccessor)this.mob.level(), this.targetBed)) {
                return true;
            }
            this.targetBed = this.findNearestBed();
            if (this.targetBed == null) {
                this.cooldown = 40;
                return false;
            }
            return true;
        }

        public boolean canContinueToUse() {
            return this.targetBed != null && this.isBed((LevelAccessor)this.mob.level(), this.targetBed) && !this.mob.getNavigation().isDone();
        }

        public void start() {
            this.moveTowardTarget();
        }

        public void tick() {
            if (this.targetBed == null) {
                return;
            }
            if (this.mob.getTarget() != null) {
                this.mob.setTarget(null);
            }
            double dist2 = this.mob.distanceToSqr((double)this.targetBed.getX() + 0.5, (double)this.targetBed.getY() + 0.5, (double)this.targetBed.getZ() + 0.5);
            if (!this.isBed((LevelAccessor)this.mob.level(), this.targetBed)) {
                this.targetBed = null;
                this.cooldown = 40;
                return;
            }
            if (dist2 <= 2.25) {
                this.mob.level().destroyBlock(this.targetBed, false);
                this.targetBed = null;
                this.cooldown = 40;
            } else if (this.mob.getNavigation().isDone()) {
                this.moveTowardTarget();
            }
        }

        private void moveTowardTarget() {
            if (this.targetBed == null) {
                return;
            }
            this.mob.getNavigation().moveTo((double)this.targetBed.getX() + 0.5, (double)this.targetBed.getY(), (double)this.targetBed.getZ() + 0.5, 1.2);
        }

        private boolean isBed(LevelAccessor level, BlockPos pos) {
            BlockState st = level.getBlockState(pos);
            return st.getBlock() instanceof BedBlock;
        }

        private BlockPos findNearestBed() {
            BlockPos origin = this.mob.blockPosition();
            RandomSource rand = this.mob.getRandom();
            int tries = 256;
            BlockPos best = null;
            double bestDist2 = Double.MAX_VALUE;
            for (int i = 0; i < 256; ++i) {
                double d2;
                int dx = rand.nextInt(101) - 50;
                int dz = rand.nextInt(101) - 50;
                int dy = rand.nextInt(17) - 8;
                BlockPos pos = origin.offset(dx, dy, dz);
                if (!this.isBed((LevelAccessor)this.mob.level(), pos) || !((d2 = pos.distSqr((Vec3i)origin)) < bestDist2)) continue;
                bestDist2 = d2;
                best = pos.immutable();
            }
            return best;
        }
    }
}

