/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class Logic49 {
    private static boolean registered = false;
    private static final Map<ResourceKey<Level>, Set<BlockPos>> PROTECTED_CHESTS = new HashMap<ResourceKey<Level>, Set<BlockPos>>();
    private static boolean active = false;

    public static void init() {
        if (registered) {
            return;
        }
        registered = true;
        NeoForge.EVENT_BUS.register((Object)new Logic49());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.level().isClientSide()) {
            return;
        }
        ServerLevel level = (ServerLevel)player2.level();
        long seed = level.getSeed();
        String key = "cm_starter_kit_given_" + seed;
        CompoundTag persistent = player2.getPersistentData();
        if (persistent.getBoolean(key).orElse(false).booleanValue()) {
            return;
        }
        this.tryProcessBonusChest(level);
        persistent.putBoolean(key, true);
    }

    private void tryProcessBonusChest(ServerLevel level) {
        int radius;
        BlockPos spawn = level.getSharedSpawnPos();
        ChestBlockEntity chest = this.findSpawnBonusChest(level, spawn, radius = 32);
        if (chest == null) {
            return;
        }
        if (level.random.nextFloat() > 0.9f) {
            return;
        }
        this.fillChestWithStarterLoot(level, chest);
    }

    private ChestBlockEntity findSpawnBonusChest(ServerLevel level, BlockPos center, int radius) {
        int minY = center.getY() - 8;
        int maxY = center.getY() + 8;
        for (int y = minY; y <= maxY; ++y) {
            for (int x = center.getX() - radius; x <= center.getX() + radius; ++x) {
                for (int z = center.getZ() - radius; z <= center.getZ() + radius; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockEntity be = level.getBlockEntity(pos);
                    if (!(be instanceof ChestBlockEntity)) continue;
                    ChestBlockEntity chest = (ChestBlockEntity)be;
                    try {
                        if (chest.getLootTable() == null || !chest.getLootTable().equals(BuiltInLootTables.SPAWN_BONUS_CHEST)) continue;
                        return chest;
                    }
                    catch (Throwable t) {
                        return chest;
                    }
                }
            }
        }
        return null;
    }

    private void fillChestWithStarterLoot(ServerLevel level, ChestBlockEntity chest) {
        try {
            if (chest.getLootTable() != null) {
                chest.unpackLootTable(null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        chest.clearContent();
        Registry enchantments = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        ItemStack helm = new ItemStack((ItemLike)Items.LEATHER_HELMET);
        helm.enchant((Holder)enchantments.getOrThrow(Enchantments.PROTECTION), 4);
        ItemStack chestplate = new ItemStack((ItemLike)Items.LEATHER_CHESTPLATE);
        chestplate.enchant((Holder)enchantments.getOrThrow(Enchantments.PROTECTION), 4);
        ItemStack leggings = new ItemStack((ItemLike)Items.LEATHER_LEGGINGS);
        leggings.enchant((Holder)enchantments.getOrThrow(Enchantments.PROTECTION), 4);
        ItemStack boots = new ItemStack((ItemLike)Items.LEATHER_BOOTS);
        boots.enchant((Holder)enchantments.getOrThrow(Enchantments.PROTECTION), 4);
        ItemStack sword = new ItemStack((ItemLike)Items.GOLDEN_SWORD);
        sword.enchant((Holder)enchantments.getOrThrow(Enchantments.SHARPNESS), 12);
        sword.enchant((Holder)enchantments.getOrThrow(Enchantments.KNOCKBACK), 3);
        ItemStack woodAxe = new ItemStack((ItemLike)Items.WOODEN_AXE);
        woodAxe.enchant((Holder)enchantments.getOrThrow(Enchantments.EFFICIENCY), 5);
        woodAxe.enchant((Holder)enchantments.getOrThrow(Enchantments.UNBREAKING), 3);
        ItemStack gapple = new ItemStack((ItemLike)Items.GOLDEN_APPLE, 1);
        ItemStack pork = new ItemStack((ItemLike)Items.COOKED_PORKCHOP, 16);
        ItemStack regenPotions = new ItemStack((ItemLike)Items.POTION, 1);
        regenPotions.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Optional.of(Potions.REGENERATION), Optional.empty(), List.of(new MobEffectInstance(MobEffects.REGENERATION, 6000, 2), new MobEffectInstance(MobEffects.ABSORPTION, 1200, 0)), Optional.empty()));
        chest.setItem(0, regenPotions);
        chest.setItem(1, helm);
        chest.setItem(2, chestplate);
        chest.setItem(3, leggings);
        chest.setItem(4, boots);
        chest.setItem(5, sword);
        chest.setItem(6, gapple);
        chest.setItem(7, pork);
        chest.setItem(8, woodAxe);
        chest.setChanged();
        PROTECTED_CHESTS.computeIfAbsent((ResourceKey<Level>)level.dimension(), k -> new HashSet()).add(chest.getBlockPos());
    }

    private static boolean isProtectedChest(ServerLevel level, BlockPos pos) {
        Set<BlockPos> set = PROTECTED_CHESTS.get(level.dimension());
        return set != null && set.contains(pos);
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockEntity be = level2.getBlockEntity(pos);
        if (be instanceof ChestBlockEntity && Logic49.isProtectedChest(level2, pos)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        BlockPos pos = event.getPos();
        if (Logic49.isProtectedChest(level, pos)) {
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof ChestBlockEntity) {
                ChestBlockEntity chest = (ChestBlockEntity)be;
                double cx = (double)pos.getX() + 0.5;
                double cy = (double)pos.getY() + 0.5;
                double cz = (double)pos.getZ() + 0.5;
                for (int i = 0; i < chest.getContainerSize(); ++i) {
                    ItemStack stack = chest.getItem(i);
                    if (stack.isEmpty()) continue;
                    ItemStack drop = stack.copy();
                    chest.setItem(i, ItemStack.EMPTY);
                    double ox = level.random.nextDouble() * 0.6 - 0.3;
                    double oz = level.random.nextDouble() * 0.6 - 0.3;
                    double vy = 0.2 + level.random.nextDouble() * 0.1;
                    double vx = (level.random.nextDouble() - 0.5) * 0.2;
                    double vz = (level.random.nextDouble() - 0.5) * 0.2;
                    ItemEntity item = new ItemEntity((Level)level, cx + ox, cy + 0.2, cz + oz, drop);
                    item.setDeltaMovement(vx, vy, vz);
                    level.addFreshEntity((Entity)item);
                }
                chest.setChanged();
            }
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 0.5;
            double z = (double)pos.getZ() + 0.5;
            level.sendParticles((ParticleOptions)ParticleTypes.CRIT, x, y, z, 30, 0.5, 0.5, 0.5, 0.1);
            Set<BlockPos> set = PROTECTED_CHESTS.get(level.dimension());
            if (set != null) {
                set.remove(pos);
            }
        }
    }
}

