/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;

public class Logic51 {
    private static boolean registered = false;
    private static final double RADIUS = 2.5;
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic51());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity ie = (ItemEntity)entity;
        if (event.getLevel().isClientSide()) {
            return;
        }
        if (!ie.getItem().is(Items.EMERALD)) {
            return;
        }
        this.tryEnchantNearbyTool(ie);
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        ItemEntity dropped = event.getEntity();
        if (dropped != null && dropped.getItem().is(Items.EMERALD)) {
            this.tryEnchantNearbyTool(dropped);
        }
    }

    private void tryEnchantNearbyTool(ItemEntity emeraldEntity) {
        Level level = emeraldEntity.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        AABB box = new AABB(emeraldEntity.getX() - 2.5, emeraldEntity.getY() - 2.5, emeraldEntity.getZ() - 2.5, emeraldEntity.getX() + 2.5, emeraldEntity.getY() + 2.5, emeraldEntity.getZ() + 2.5);
        List nearby = level.getEntitiesOfClass(ItemEntity.class, box);
        ItemEntity targetTool = null;
        for (ItemEntity ie : nearby) {
            ItemStack st;
            if (ie == emeraldEntity || !this.isToolLike(st = ie.getItem())) continue;
            targetTool = ie;
            break;
        }
        if (targetTool == null) {
            return;
        }
        if (this.getEnchantCount(targetTool.getItem()) >= 3) {
            return;
        }
        ItemStack emeralds = emeraldEntity.getItem();
        if (emeralds.getCount() <= 0) {
            return;
        }
        emeralds.shrink(1);
        if (emeralds.getCount() <= 0) {
            emeraldEntity.discard();
        } else {
            emeraldEntity.setItem(emeralds);
        }
        ItemStack toolStack = targetTool.getItem();
        this.applyRandomEnchant(sl, toolStack);
        targetTool.setItem(toolStack);
        sl.playSound(null, targetTool.getX(), targetTool.getY(), targetTool.getZ(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
        sl.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, targetTool.getX(), targetTool.getY() + 0.25, targetTool.getZ(), 30, 0.4, 0.4, 0.4, 0.15);
    }

    private boolean isToolLike(ItemStack st) {
        if (st == null || st.isEmpty()) {
            return false;
        }
        return st.is(Items.WOODEN_SWORD) || st.is(Items.STONE_SWORD) || st.is(Items.IRON_SWORD) || st.is(Items.GOLDEN_SWORD) || st.is(Items.DIAMOND_SWORD) || st.is(Items.NETHERITE_SWORD) || st.is(Items.WOODEN_PICKAXE) || st.is(Items.STONE_PICKAXE) || st.is(Items.IRON_PICKAXE) || st.is(Items.GOLDEN_PICKAXE) || st.is(Items.DIAMOND_PICKAXE) || st.is(Items.NETHERITE_PICKAXE) || st.is(Items.WOODEN_AXE) || st.is(Items.STONE_AXE) || st.is(Items.IRON_AXE) || st.is(Items.GOLDEN_AXE) || st.is(Items.DIAMOND_AXE) || st.is(Items.NETHERITE_AXE) || st.is(Items.WOODEN_SHOVEL) || st.is(Items.STONE_SHOVEL) || st.is(Items.IRON_SHOVEL) || st.is(Items.GOLDEN_SHOVEL) || st.is(Items.DIAMOND_SHOVEL) || st.is(Items.NETHERITE_SHOVEL) || st.is(Items.WOODEN_HOE) || st.is(Items.STONE_HOE) || st.is(Items.IRON_HOE) || st.is(Items.GOLDEN_HOE) || st.is(Items.DIAMOND_HOE) || st.is(Items.NETHERITE_HOE) || st.is(Items.SHEARS) || st.is(Items.FISHING_ROD) || st.is(Items.BOW) || st.is(Items.CROSSBOW) || st.is(Items.TRIDENT);
    }

    private void applyRandomEnchant(ServerLevel level, ItemStack stack) {
        Registry enchRegistry = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        if (this.getEnchantCount(stack) >= 3) {
            return;
        }
        List<EnchantmentChoice> candidates = this.getCandidatesFor(stack, (HolderGetter<Enchantment>)enchRegistry);
        if (candidates.isEmpty()) {
            return;
        }
        RandomSource rnd = level.getRandom();
        EnchantmentChoice choice = candidates.get(rnd.nextInt(candidates.size()));
        int lvl = choice.randomLevel(rnd);
        stack.enchant(choice.enchantment(), lvl);
    }

    private int getEnchantCount(ItemStack stack) {
        ItemEnchantments ench = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
        return ench == null ? 0 : ench.size();
    }

    private List<EnchantmentChoice> getCandidatesFor(ItemStack stack, HolderGetter<Enchantment> reg) {
        ArrayList<EnchantmentChoice> list = new ArrayList<EnchantmentChoice>();
        if (stack.is(Items.SHEARS) || stack.is(Items.WOODEN_PICKAXE) || stack.is(Items.STONE_PICKAXE) || stack.is(Items.IRON_PICKAXE) || stack.is(Items.GOLDEN_PICKAXE) || stack.is(Items.DIAMOND_PICKAXE) || stack.is(Items.NETHERITE_PICKAXE) || stack.is(Items.WOODEN_AXE) || stack.is(Items.STONE_AXE) || stack.is(Items.IRON_AXE) || stack.is(Items.GOLDEN_AXE) || stack.is(Items.DIAMOND_AXE) || stack.is(Items.NETHERITE_AXE) || stack.is(Items.WOODEN_SHOVEL) || stack.is(Items.STONE_SHOVEL) || stack.is(Items.IRON_SHOVEL) || stack.is(Items.GOLDEN_SHOVEL) || stack.is(Items.DIAMOND_SHOVEL) || stack.is(Items.NETHERITE_SHOVEL) || stack.is(Items.WOODEN_HOE) || stack.is(Items.STONE_HOE) || stack.is(Items.IRON_HOE) || stack.is(Items.GOLDEN_HOE) || stack.is(Items.DIAMOND_HOE) || stack.is(Items.NETHERITE_HOE)) {
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.EFFICIENCY), 1, 2));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.UNBREAKING), 1, 2));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.FORTUNE), 1, 2));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.SILK_TOUCH), 1, 1));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.MENDING), 1, 1));
        }
        if (stack.is(Items.WOODEN_SWORD) || stack.is(Items.STONE_SWORD) || stack.is(Items.IRON_SWORD) || stack.is(Items.GOLDEN_SWORD) || stack.is(Items.DIAMOND_SWORD) || stack.is(Items.NETHERITE_SWORD)) {
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.SHARPNESS), 1, 5));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.SMITE), 1, 5));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.BANE_OF_ARTHROPODS), 1, 5));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.KNOCKBACK), 1, 2));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.FIRE_ASPECT), 1, 2));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.LOOTING), 1, 3));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.SWEEPING_EDGE), 1, 3));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.UNBREAKING), 1, 3));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.MENDING), 1, 1));
        }
        if (stack.is(Items.BOW)) {
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.POWER), 1, 5));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.PUNCH), 1, 2));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.FLAME), 1, 1));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.INFINITY), 1, 1));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.UNBREAKING), 1, 3));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.MENDING), 1, 1));
        }
        if (stack.is(Items.CROSSBOW)) {
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.QUICK_CHARGE), 1, 3));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.MULTISHOT), 1, 1));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.PIERCING), 1, 4));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.UNBREAKING), 1, 3));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.MENDING), 1, 1));
        }
        if (stack.is(Items.TRIDENT)) {
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.LOYALTY), 1, 3));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.RIPTIDE), 1, 3));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.CHANNELING), 1, 1));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.IMPALING), 1, 5));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.UNBREAKING), 1, 3));
            list.add(new EnchantmentChoice((Holder<Enchantment>)reg.getOrThrow(Enchantments.MENDING), 1, 1));
        }
        return list;
    }

    private record EnchantmentChoice(Holder<Enchantment> enchantment, int minLevel, int maxLevel) {
        int randomLevel(RandomSource rnd) {
            if (this.maxLevel <= this.minLevel) {
                return Math.max(5, this.minLevel);
            }
            return this.minLevel + rnd.nextInt(this.maxLevel - this.minLevel + 1);
        }
    }
}

