/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class Logic6 {
    private static boolean active = false;
    private static final int SEARCH_RADIUS = 20;
    private static final int BREAK_RADIUS = 5;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic6());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onServerTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level.isClientSide()) {
            return;
        }
        if (level.getGameTime() % 20L != 0L) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (Player player : serverLevel.players()) {
                AABB searchArea = new AABB(player.getX() - 20.0, player.getY() - 20.0, player.getZ() - 20.0, player.getX() + 20.0, player.getY() + 20.0, player.getZ() + 20.0);
                List zombies = serverLevel.getEntitiesOfClass(Zombie.class, searchArea);
                for (Zombie zombie : zombies) {
                    if (zombie.getTarget() == null || !Logic6.isZombieStuck(zombie)) continue;
                    Logic6.breakBlocksInPath(zombie, serverLevel);
                }
            }
        }
    }

    private static boolean isZombieStuck(Zombie zombie) {
        Vec3 motion = zombie.getDeltaMovement();
        return Math.abs(motion.x) < 0.01 && Math.abs(motion.z) < 0.01;
    }

    private static void breakBlocksInPath(Zombie zombie, ServerLevel level) {
        double dz;
        double dy;
        if (zombie.getTarget() == null) {
            return;
        }
        double dx = zombie.getTarget().getX() - zombie.getX();
        double length = Math.sqrt(dx * dx + (dy = zombie.getTarget().getY() - zombie.getY()) * dy + (dz = zombie.getTarget().getZ() - zombie.getZ()) * dz);
        if (length < 0.1) {
            return;
        }
        dx /= length;
        dy /= length;
        dz /= length;
        for (int i = 1; i <= 5; ++i) {
            BlockPos checkPos = BlockPos.containing((double)(zombie.getX() + dx * (double)i), (double)(zombie.getEyeY() + dy * (double)i - 0.5), (double)(zombie.getZ() + dz * (double)i));
            BlockState state = level.getBlockState(checkPos);
            if (state.isAir() || !(state.getDestroySpeed((BlockGetter)level, checkPos) >= 0.0f)) continue;
            level.destroyBlock(checkPos, true, (Entity)zombie);
            break;
        }
    }
}

