/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

public class Logic8 {
    private static final int INFINITE_DURATION_TICKS = Integer.MAX_VALUE;
    private static final double CHANCE_ONE_OR_MORE = 0.5;
    private static final double CHANCE_TRIPLE = 0.4;
    private static final Random RNG = new Random();
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic8());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Level level = event.getLevel();
        if (level.isClientSide()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Zombie)) {
            return;
        }
        Zombie zombie = (Zombie)entity;
        if (Logic8.roll(0.4)) {
            Logic8.applyRandomEffects(level, zombie, 3);
            return;
        }
        if (Logic8.roll(0.5)) {
            Logic8.applyRandomEffects(level, zombie, 1);
        }
    }

    private static boolean roll(double chance) {
        return RNG.nextDouble() < chance;
    }

    private static void applyRandomEffects(Level level, Zombie zombie, int count) {
        List<MobEffectInstance> pool = Logic8.buildEffectPool(level);
        Collections.shuffle(pool, RNG);
        int applied = 0;
        for (MobEffectInstance inst : pool) {
            if (zombie.hasEffect(inst.getEffect())) continue;
            zombie.addEffect(inst);
            if (++applied < count) continue;
            break;
        }
    }

    private static List<MobEffectInstance> buildEffectPool(Level level) {
        int amp0 = RNG.nextBoolean() ? 0 : 1;
        int amp1 = RNG.nextBoolean() ? 0 : 1;
        int amp2 = RNG.nextBoolean() ? 0 : 1;
        int amp3 = RNG.nextBoolean() ? 0 : 1;
        int amp4 = RNG.nextBoolean() ? 0 : 1;
        int amp5 = RNG.nextBoolean() ? 0 : 1;
        int amp6 = RNG.nextBoolean() ? 0 : 1;
        int amp7 = RNG.nextBoolean() ? 0 : 1;
        Registry registry = level.registryAccess().lookupOrThrow(Registries.MOB_EFFECT);
        ArrayList<MobEffectInstance> list = new ArrayList<MobEffectInstance>();
        Logic8.addIfPresent(list, (HolderLookup<MobEffect>)registry, "speed", Integer.MAX_VALUE, amp0);
        Logic8.addIfPresent(list, (HolderLookup<MobEffect>)registry, "strength", Integer.MAX_VALUE, amp1);
        Logic8.addIfPresent(list, (HolderLookup<MobEffect>)registry, "jump_boost", Integer.MAX_VALUE, amp2);
        Logic8.addIfPresent(list, (HolderLookup<MobEffect>)registry, "resistance", Integer.MAX_VALUE, amp3);
        Logic8.addIfPresent(list, (HolderLookup<MobEffect>)registry, "regeneration", Integer.MAX_VALUE, amp4);
        Logic8.addIfPresent(list, (HolderLookup<MobEffect>)registry, "fire_resistance", Integer.MAX_VALUE, amp5);
        Logic8.addIfPresent(list, (HolderLookup<MobEffect>)registry, "night_vision", Integer.MAX_VALUE, amp6);
        Logic8.addIfPresent(list, (HolderLookup<MobEffect>)registry, "health_boost", Integer.MAX_VALUE, amp7);
        return list;
    }

    private static void addIfPresent(List<MobEffectInstance> out, HolderLookup<MobEffect> registry, String key, int duration, int amplifier) {
        ResourceLocation id = ResourceLocation.withDefaultNamespace((String)key);
        ResourceKey resKey = ResourceKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)id);
        registry.get(resKey).ifPresent(effect -> out.add(new MobEffectInstance((Holder)effect, duration, amplifier, true, true)));
    }
}

