/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.Random;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

public class Logic9 {
    private static final double CHANCE_HAS_SWORD = 0.3;
    private static final double CHANCE_HAS_ARMOR = 0.5;
    private static final Random RNG = new Random();
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic9());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Level level = event.getLevel();
        if (level.isClientSide()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Zombie)) {
            return;
        }
        Zombie zombie = (Zombie)entity;
        if (RNG.nextDouble() < 0.3) {
            Item randomSword = Logic9.pickRandomSword();
            ItemStack stack = new ItemStack((ItemLike)randomSword);
            zombie.setItemInHand(InteractionHand.MAIN_HAND, stack);
            zombie.setDropChance(EquipmentSlot.MAINHAND, 0.05f);
        }
        if (RNG.nextDouble() < 0.5) {
            Logic9.equipRandomArmorSubset(zombie);
        }
    }

    private static Item pickRandomSword() {
        Item[] swords = new Item[]{Items.WOODEN_SWORD, Items.STONE_SWORD, Items.IRON_SWORD, Items.GOLDEN_SWORD, Items.DIAMOND_SWORD};
        return swords[RNG.nextInt(swords.length)];
    }

    private static void equipRandomArmorSubset(Zombie zombie) {
        Item legs;
        Item chest;
        Item helmet;
        int tier = RNG.nextInt(5);
        Item boots = switch (tier) {
            case 0 -> {
                helmet = Items.LEATHER_HELMET;
                chest = Items.LEATHER_CHESTPLATE;
                legs = Items.LEATHER_LEGGINGS;
                yield Items.LEATHER_BOOTS;
            }
            case 1 -> {
                helmet = Items.CHAINMAIL_HELMET;
                chest = Items.CHAINMAIL_CHESTPLATE;
                legs = Items.CHAINMAIL_LEGGINGS;
                yield Items.CHAINMAIL_BOOTS;
            }
            case 2 -> {
                helmet = Items.IRON_HELMET;
                chest = Items.IRON_CHESTPLATE;
                legs = Items.IRON_LEGGINGS;
                yield Items.IRON_BOOTS;
            }
            case 3 -> {
                helmet = Items.GOLDEN_HELMET;
                chest = Items.GOLDEN_CHESTPLATE;
                legs = Items.GOLDEN_LEGGINGS;
                yield Items.GOLDEN_BOOTS;
            }
            default -> {
                helmet = Items.DIAMOND_HELMET;
                chest = Items.DIAMOND_CHESTPLATE;
                legs = Items.DIAMOND_LEGGINGS;
                yield Items.DIAMOND_BOOTS;
            }
        };
        int mask = RNG.nextInt(15) + 1;
        if ((mask & 1) != 0) {
            zombie.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)helmet));
            zombie.setDropChance(EquipmentSlot.HEAD, 0.0f);
        }
        if ((mask & 2) != 0) {
            zombie.setItemSlot(EquipmentSlot.CHEST, new ItemStack((ItemLike)chest));
            zombie.setDropChance(EquipmentSlot.CHEST, 0.0f);
        }
        if ((mask & 4) != 0) {
            zombie.setItemSlot(EquipmentSlot.LEGS, new ItemStack((ItemLike)legs));
            zombie.setDropChance(EquipmentSlot.LEGS, 0.0f);
        }
        if ((mask & 8) != 0) {
            zombie.setItemSlot(EquipmentSlot.FEET, new ItemStack((ItemLike)boots));
            zombie.setDropChance(EquipmentSlot.FEET, 0.0f);
        }
    }
}

