/*
 * Decompiled with CFR 0.152.
 */
package dev.omni.breedingtimer.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class TimerHudConfig {
    private static final File CONFIG_FILE = new File("config/breedingtimer.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public int timerMinutes = 10;
    public boolean soundEnabled = true;

    public static TimerHudConfig load() {
        if (CONFIG_FILE.exists()) {
            TimerHudConfig timerHudConfig;
            FileReader reader = new FileReader(CONFIG_FILE);
            try {
                timerHudConfig = (TimerHudConfig)GSON.fromJson((Reader)reader, TimerHudConfig.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            reader.close();
            return timerHudConfig;
        }
        TimerHudConfig config = new TimerHudConfig();
        config.save();
        return config;
    }

    public void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

