/*
 * Decompiled with CFR 0.152.
 */
package dev.omni.breedingtimer.client;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.omni.breedingtimer.client.TimerHudConfig;
import dev.omni.breedingtimer.client.TimerHudOverlay;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;

@Environment(value=EnvType.CLIENT)
public class BreedingtimerClient
implements ClientModInitializer {
    private static class_304 startKey;
    private static class_304 toggleKey;
    public static TimerHudConfig config;
    private static int timerTicks;
    private static int MAX_TICKS;
    static boolean timerVisible;

    public void onInitializeClient() {
        config = TimerHudConfig.load();
        MAX_TICKS = BreedingtimerClient.config.timerMinutes * 60 * 20;
        startKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.breedingtimer.start", class_3675.class_307.field_1668, 72, "category.breedingtimer"));
        toggleKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.breedingtimer.toggle", class_3675.class_307.field_1668, 79, "category.breedingtimer"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (startKey.method_1436()) {
                timerTicks = MAX_TICKS;
                if (client.field_1724 == null) continue;
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aBreeding Timer started"), false);
            }
            while (toggleKey.method_1436()) {
                boolean bl = timerVisible = !timerVisible;
                if (client.field_1724 == null) continue;
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)(timerVisible ? "\u00a7aTimer resumed" : "\u00a7cTimer paused/hidden")), false);
            }
            if (timerTicks > 0 && timerVisible && --timerTicks == 0 && client.field_1724 != null) {
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u00a7lBreeding Timer Done!"), false);
                client.field_1705.method_34004((class_2561)class_2561.method_43470((String)"\u00a7c\u00a7lTIME'S UP!"));
                client.field_1705.method_34002((class_2561)class_2561.method_43470((String)"Restarting..."));
                timerTicks = MAX_TICKS;
            }
        });
        HudRenderCallback.EVENT.register((Object)new TimerHudOverlay());
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"breedingtimer").then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"minutes", (ArgumentType)IntegerArgumentType.integer((int)1, (int)120)).executes(ctx -> {
            int minutes;
            BreedingtimerClient.config.timerMinutes = minutes = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"minutes");
            config.save();
            MAX_TICKS = minutes * 60 * 20;
            class_310 client = class_310.method_1551();
            if (client.field_1724 != null) {
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7aBreeding timer set to " + minutes + " minutes.")), false);
            }
            return 1;
        })))).then(ClientCommandManager.literal((String)"get").executes(ctx -> {
            class_310 client = class_310.method_1551();
            if (client.field_1724 != null) {
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7eBreeding timer is currently set to " + BreedingtimerClient.config.timerMinutes + " minutes.")), false);
            }
            return 1;
        }))).then(ClientCommandManager.literal((String)"toggle").executes(ctx -> {
            timerVisible = !timerVisible;
            class_310 client = class_310.method_1551();
            if (client.field_1724 != null) {
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)(timerVisible ? "\u00a7aTimer resumed" : "\u00a7cTimer paused/hidden")), false);
            }
            return 1;
        }))));
    }

    public static String getTimerDisplay() {
        if (!timerVisible || timerTicks < 0) {
            return "";
        }
        int seconds = timerTicks / 20;
        int minutes = seconds / 60;
        return String.format("%02d:%02d", minutes, seconds %= 60);
    }

    static {
        timerTicks = -1;
        timerVisible = true;
    }
}

