/*
 * Decompiled with CFR 0.152.
 */
package com.tcoded.nochatreports.nms.v1_19_4;

import com.tcoded.nochatreports.nms.NmsProvider;
import com.tcoded.nochatreports.nms.channel.ChannelInjector;
import com.tcoded.nochatreports.nms.channel.GlobalPacketHandler;
import com.tcoded.nochatreports.nms.types.NmsProviderConfig;
import com.tcoded.nochatreports.nms.v1_19_4.channel.ChannelInjectorImpl;
import com.tcoded.nochatreports.nms.v1_19_4.channel.GlobalPacketHandlerImpl;
import com.tcoded.nochatreports.nms.v1_19_4.listener.ClientboundPlayerChatListener;
import com.tcoded.nochatreports.nms.v1_19_4.listener.ClientboundServerDataPacketListener;
import com.tcoded.nochatreports.nms.v1_19_4.listener.ClientboundServerStatusListener;
import com.tcoded.nochatreports.nms.v1_19_4.listener.ServerboundChatSessionUpdateListener;
import com.tcoded.nochatreports.nms.v1_19_4.wrapper.PlayerChatPacketImpl;
import com.tcoded.nochatreports.nms.wrapper.PlayerChatPacket;
import com.tcoded.nochatreports.nms.wrapper.SystemChatPacket;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Method;
import java.util.Properties;
import joptsimple.OptionSet;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class NmsProviderImpl
extends NmsProvider<EntityPlayer> {
    private final GlobalPacketHandler globalPacketHandler;
    private final ChannelInjector channelInjector;

    public NmsProviderImpl(NmsProviderConfig nmsConfig) {
        super(nmsConfig);
        DedicatedServer server = (DedicatedServer)MinecraftServer.getServer();
        server.u.a(config -> {
            Properties newProps = new Properties(config.Y);
            newProps.setProperty("enforce-secure-profile", String.valueOf(false));
            try {
                Class<?> serverPropsClass = config.getClass();
                Method reloadMethod = serverPropsClass.getDeclaredMethod("reload", IRegistryCustom.class, Properties.class, OptionSet.class);
                boolean prev = reloadMethod.isAccessible();
                reloadMethod.setAccessible(true);
                DedicatedServerProperties newServerProps = (DedicatedServerProperties)reloadMethod.invoke(config, server.aX(), newProps, server.options);
                reloadMethod.setAccessible(prev);
                return newServerProps;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.globalPacketHandler = new GlobalPacketHandlerImpl(this);
        this.channelInjector = new ChannelInjectorImpl(this, this.globalPacketHandler);
    }

    @Override
    public PlayerChatPacket wrapChatPacket(ByteBuf byteBuf) {
        return new PlayerChatPacketImpl(byteBuf);
    }

    @Override
    public void sendSystemPacket(Player player, SystemChatPacket systemPacket) {
        EntityPlayer nmsPlayer = this.getNmsPlayer(player);
        Packet nmsPacket = (Packet)systemPacket.toNmsPacket();
        nmsPlayer.b.a(nmsPacket);
    }

    @Override
    public EntityPlayer getNmsPlayer(Player player) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        return craftPlayer.getHandle();
    }

    @Override
    public GlobalPacketHandler getGlobalPacketHandler() {
        return this.globalPacketHandler;
    }

    @Override
    public ChannelInjector getChannelInjector() {
        return this.channelInjector;
    }

    @Override
    public void registerListeners() {
        this.getGlobalPacketHandler().addListener(new ClientboundPlayerChatListener(this));
        this.getGlobalPacketHandler().addListener(new ClientboundServerDataPacketListener(this));
        this.getGlobalPacketHandler().addListener(new ClientboundServerStatusListener(this));
        this.getGlobalPacketHandler().addListener(new ServerboundChatSessionUpdateListener(this));
    }

    @Override
    public PlayerChatPacket wrapChatPacket(Object packet) {
        if (packet instanceof ClientboundPlayerChatPacket) {
            ClientboundPlayerChatPacket chatPacket = (ClientboundPlayerChatPacket)packet;
            return new PlayerChatPacketImpl(chatPacket);
        }
        return null;
    }
}

