/*
 * Decompiled with CFR 0.152.
 */
package com.tcoded.nochatreports.nms.v1_21_5;

import com.tcoded.nochatreports.nms.NmsProvider;
import com.tcoded.nochatreports.nms.channel.ChannelInjector;
import com.tcoded.nochatreports.nms.channel.GlobalPacketHandler;
import com.tcoded.nochatreports.nms.types.NmsProviderConfig;
import com.tcoded.nochatreports.nms.v1_21_5.channel.ChannelInjectorImpl;
import com.tcoded.nochatreports.nms.v1_21_5.channel.GlobalPacketHandlerImpl;
import com.tcoded.nochatreports.nms.v1_21_5.listener.ClientboundLoginListener;
import com.tcoded.nochatreports.nms.v1_21_5.listener.ClientboundPlayerChatListener;
import com.tcoded.nochatreports.nms.v1_21_5.listener.ServerboundChatSessionUpdateListener;
import com.tcoded.nochatreports.nms.v1_21_5.wrapper.PlayerChatPacketImpl;
import com.tcoded.nochatreports.nms.wrapper.PlayerChatPacket;
import com.tcoded.nochatreports.nms.wrapper.SystemChatPacket;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Method;
import java.util.Properties;
import joptsimple.OptionSet;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class NmsProviderImpl
extends NmsProvider<EntityPlayer> {
    private final GlobalPacketHandler globalPacketHandler;
    private final ChannelInjector channelInjector;

    public NmsProviderImpl(NmsProviderConfig nmsConfig) {
        super(nmsConfig);
        DedicatedServer server = (DedicatedServer)MinecraftServer.getServer();
        server.s.a(config -> {
            Properties newProps = new Properties(config.ac);
            newProps.setProperty("enforce-secure-profile", String.valueOf(false));
            if (this.getConfig().isPaper()) {
                return config.reload((IRegistryCustom)server.ba(), newProps, server.options);
            }
            try {
                Method reloadMethod = config.getClass().getDeclaredMethod("reload", IRegistryCustom.class, Properties.class, OptionSet.class);
                boolean prevAccessible = reloadMethod.isAccessible();
                reloadMethod.setAccessible(true);
                Object retValue = reloadMethod.invoke(config, server.ba(), newProps, server.options);
                reloadMethod.setAccessible(prevAccessible);
                return (DedicatedServerProperties)retValue;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
        this.globalPacketHandler = new GlobalPacketHandlerImpl(this);
        this.channelInjector = new ChannelInjectorImpl(this, this.globalPacketHandler);
    }

    @Override
    public PlayerChatPacket wrapChatPacket(ByteBuf byteBuf) {
        return new PlayerChatPacketImpl(byteBuf);
    }

    @Override
    public void sendSystemPacket(Player player, SystemChatPacket systemPacket) {
        EntityPlayer nmsPlayer = this.getNmsPlayer(player);
        Packet nmsPacket = (Packet)systemPacket.toNmsPacket();
        nmsPlayer.f.sendPacket(nmsPacket);
    }

    @Override
    public EntityPlayer getNmsPlayer(Player player) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        if (this.getConfig().isPaper()) {
            return (EntityPlayer)craftPlayer.getHandleRaw();
        }
        return craftPlayer.getHandle();
    }

    @Override
    public GlobalPacketHandler getGlobalPacketHandler() {
        return this.globalPacketHandler;
    }

    @Override
    public ChannelInjector getChannelInjector() {
        return this.channelInjector;
    }

    @Override
    public void registerListeners() {
        this.getGlobalPacketHandler().addListener(new ClientboundPlayerChatListener(this));
        this.getGlobalPacketHandler().addListener(new ServerboundChatSessionUpdateListener(this));
        this.getGlobalPacketHandler().addListener(new ClientboundLoginListener(this));
    }

    @Override
    public PlayerChatPacket wrapChatPacket(Object packet) {
        if (packet instanceof ClientboundPlayerChatPacket) {
            ClientboundPlayerChatPacket chatPacket = (ClientboundPlayerChatPacket)packet;
            return new PlayerChatPacketImpl(chatPacket);
        }
        return null;
    }
}

