/*
 * Decompiled with CFR 0.152.
 */
package com.tcoded.nochatreports.plugin;

import com.tcoded.nochatreports.lib.spigotupdatechecker.SimpleUpdateChecker;
import com.tcoded.nochatreports.nms.NmsProvider;
import com.tcoded.nochatreports.nms.types.NmsProviderConfig;
import com.tcoded.nochatreports.plugin.hook.ViaHook;
import com.tcoded.nochatreports.plugin.lib.folialib.FoliaLib;
import com.tcoded.nochatreports.plugin.listener.JoinListener;
import com.tcoded.nochatreports.plugin.listener.KickListener;
import com.tcoded.nochatreports.plugin.listener.PacketListener;
import com.tcoded.nochatreports.plugin.util.PluginUtil;
import com.tcoded.nochatreports.plugin.util.SimpleLogFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class NoChatReports
extends JavaPlugin {
    private static final int SPIGOT_RESOURCE_ID = 102931;
    public final List<Plugin> pls = new ArrayList<Plugin>();
    private NmsProvider<?> nmsProvider;
    private FoliaLib foliaLib;
    public boolean disWarn;
    private boolean debug;

    public void onLoad() {
        Plugin ess;
        this.saveDefaultConfig();
        try {
            InputStream defaultConfigStream = this.getResource("config.yml");
            if (defaultConfigStream == null) {
                throw new Exception("Default config not found!");
            }
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultConfigStream));
            this.getConfig().setDefaults((Configuration)defaultConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new SimpleLogFilter(this.getLogger(), record -> {
            boolean isVersionError = record.getMessage().contains("[packetevents] We currently do not support the minecraft version");
            if (isVersionError) {
                record.setLevel(Level.INFO);
            }
            return true;
        });
        PluginManager pluginManager = this.getServer().getPluginManager();
        this.disWarn = this.getConfig().getBoolean("disable-plugin-policing", true);
        Plugin via = PluginUtil.getPlugin(this, "ViaVersion");
        if (via != null) {
            this.pls.add(via);
            if (!this.disWarn) {
                this.getLogger().warning("\n***\nYikes, ViaVersion detection!\nPlease note that ViaVersion claims that dangerous issues are present when an anti-chat-reporting plugin is installed. Please ignore any fake and scary messages found below. Feel free to test for real incompatibilities, you are unlikely to find any.\n- Please report any *real* issues to my GitHub page :) -\n***");
            }
        }
        if ((ess = PluginUtil.getPlugin(this, "Essentials")) != null) {
            this.pls.add(ess);
            if (!this.disWarn) {
                this.getLogger().warning("EssentialsX note: Essentials may claim that an anti-chat-reporting plugin is 'unsupported' when installed. It is safe to ignore any 'unsupported' messages below. Feel free to test for incompatibilities, there are no known problems. If you do find a bug, please report any issues to my GitHub :)");
            }
        }
    }

    public void onEnable() {
        this.foliaLib = new FoliaLib(this);
        String bukkitVersion = this.getServer().getBukkitVersion();
        String mcVersion = bukkitVersion.substring(0, bukkitVersion.indexOf("-"));
        this.debug = this.getConfig().getBoolean("debug-mode", false);
        this.getLogger().info("Loading support for Minecraft version: " + mcVersion);
        this.nmsProvider = NmsProvider.getNmsProvider(mcVersion, new NmsProviderConfig(this.foliaLib.isFolia() || this.foliaLib.isPaper(), this::isDebug));
        if (this.nmsProvider == null) {
            this.getLogger().severe("Failed to load NMS provider for Minecraft version: " + mcVersion);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        NmsProvider nms = this.getNmsProvider();
        nms.getChannelInjector().injectAll(this.getServer().getOnlinePlayers());
        nms.registerListeners();
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new JoinListener(this, nms.getChannelInjector()), (Plugin)this);
        pluginManager.registerEvents((Listener)new PacketListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new KickListener(this.getConfig().getString("prevented-kick-message"), this.getConfig().getStringList("invalid-kick-reasons")), (Plugin)this);
        Consumer<Runnable> asyncConsumer = runnable -> this.foliaLib.getScheduler().runAsync(wt -> runnable.run());
        SimpleUpdateChecker.checkUpdate(this, "[NoChatReports] ", 102931, asyncConsumer);
        ViaHook.hookIfPresent(this);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void onDisable() {
        this.nmsProvider.getChannelInjector().uninjectAll(this.getServer().getOnlinePlayers());
        HandlerList.unregisterAll((Plugin)this);
    }

    public ConsoleCommandSender getConsoleSender() {
        return this.getServer().getConsoleSender();
    }

    public NmsProvider getNmsProvider() {
        return this.nmsProvider;
    }
}

