/*
 * Decompiled with CFR 0.152.
 */
package com.tcoded.nochatreports.plugin.hook;

import com.tcoded.nochatreports.plugin.NoChatReports;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.ViaAPI;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class ViaHook
implements Listener {
    private final int SERVER_DATA_PACKET_MAX_PROTO = ProtocolVersion.v1_20_3.getVersion();
    private final Logger logger;
    private final ViaAPI api;
    private final int serverProto;
    private boolean alreadyReceivedDetails;
    private Supplier<Boolean> debugStateSupplier;

    public static void hookIfPresent(NoChatReports plugin) {
        boolean showDetails = plugin.getConfig().getBoolean("details-for-unsupported-clients", true);
        if (!showDetails) {
            return;
        }
        boolean viaEnabled = plugin.getServer().getPluginManager().isPluginEnabled("ViaVersion");
        if (!viaEnabled) {
            return;
        }
        ViaHook.hookVia(plugin);
    }

    private static void hookVia(NoChatReports plugin) {
        ViaHook viaHook = new ViaHook(plugin.getLogger(), plugin::isDebug);
        if (!viaHook.shouldRegister()) {
            return;
        }
        plugin.getServer().getPluginManager().registerEvents((Listener)viaHook, (Plugin)plugin);
    }

    public ViaHook(Logger logger, Supplier<Boolean> debugStateSupplier) {
        this.logger = logger;
        this.api = Via.getAPI();
        this.serverProto = this.api.getServerVersion().highestSupportedProtocolVersion().getVersion();
        this.debugStateSupplier = debugStateSupplier;
    }

    public boolean shouldRegister() {
        return this.serverProto <= this.SERVER_DATA_PACKET_MAX_PROTO;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        int playerProto;
        try {
            playerProto = this.api.getPlayerProtocolVersion((Object)event.getPlayer()).getVersion();
        }
        catch (Exception e) {
            if (!this.debugStateSupplier.get().booleanValue()) {
                return;
            }
            e.printStackTrace();
            return;
        }
        if (playerProto > this.SERVER_DATA_PACKET_MAX_PROTO) {
            this.logger.info(event.getPlayer().getName() + " joined using ViaVersion on a higher version. They will see the insecure chat popup.");
            if (this.alreadyReceivedDetails) {
                return;
            }
            this.alreadyReceivedDetails = true;
            String msg = "Quick warning about clients on higher Minecraft version than your server:\n{PLAYER_NAME} joined using ViaVersion with a client version of 1.20.5 or higher.\n\nThey will therefore see the scary insecure chat popup.\nThis will NOT prevent NCR from blocking chat reports. Only the popup.\nThese details will only be shown *once* per reboot and can also be disabled permanently in the config.\n\nWhy the popup?\nMinecraft versions from 1.19 to 1.20.4 use a separate data packet to inform the clients of the chat reporting status.\nMinecraft versions starting from 1.20.6 and higher include this information in the login sequence.\nHowever, the data packet sent by 1.19-1.20.4 servers is sent after the player has logged in.\nViaVersion is therefore unable to convert the information for 1.20.5(or +) clients since it is sent after it is needed.\n\nUpdating the server version is the best way to resolve this.\n".replace("{PLAYER_NAME}", event.getPlayer().getName());
            for (String line : msg.split("\n")) {
                this.logger.warning(line);
            }
        }
    }
}

