/*
 * Decompiled with CFR 0.152.
 */
package com.tcoded.nochatreports.lib.spigotupdatechecker;

import com.tcoded.nochatreports.lib.spigotupdatechecker.UpdateResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class UpdateChecker {
    private URL checkURL;
    private final String[] currVersionSections;
    private String availableVersion;
    private final UpdateResult result;

    public UpdateChecker(String currentVersion, Integer resourceId) {
        this.currVersionSections = currentVersion.split("\\.");
        this.result = new UpdateResult(UpdateResult.Type.FAIL_SPIGOT, null, currentVersion);
        try {
            this.checkURL = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + resourceId);
        }
        catch (MalformedURLException e) {
            this.result.setType(UpdateResult.Type.FAIL_SPIGOT);
            return;
        }
        this.run();
    }

    private void run() {
        URLConnection con;
        try {
            con = this.checkURL.openConnection();
        }
        catch (IOException e1) {
            this.result.setType(UpdateResult.Type.FAIL_SPIGOT);
            return;
        }
        try {
            this.availableVersion = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
        }
        catch (IOException e) {
            this.result.setType(UpdateResult.Type.FAIL_SPIGOT);
            return;
        }
        if (this.availableVersion.isEmpty()) {
            this.result.setType(UpdateResult.Type.FAIL_SPIGOT);
            return;
        }
        this.result.setLatestVer(this.availableVersion);
        String[] versionSections = this.availableVersion.split("\\.");
        for (int i = 0; i < versionSections.length || i < this.currVersionSections.length; ++i) {
            try {
                int cvSecInt;
                boolean cvSecExists;
                boolean vSecExists = versionSections.length - i > 0;
                boolean bl = cvSecExists = this.currVersionSections.length - i > 0;
                if (!vSecExists) {
                    this.result.setType(UpdateResult.Type.DEV_BUILD);
                    return;
                }
                if (!cvSecExists) {
                    this.result.setType(this.getUpdateResultPriority(i));
                    return;
                }
                int vSecInt = Integer.parseInt(versionSections[i]);
                if (vSecInt > (cvSecInt = Integer.parseInt(this.currVersionSections[i]))) {
                    this.result.setType(this.getUpdateResultPriority(i));
                    return;
                }
                if (cvSecInt <= vSecInt) continue;
                this.result.setType(UpdateResult.Type.DEV_BUILD);
                return;
            }
            catch (NumberFormatException e) {
                this.result.setType(UpdateResult.Type.UNKNOWN_VERSION);
                return;
            }
        }
        this.result.setType(UpdateResult.Type.NO_UPDATE);
    }

    public UpdateResult getResult() {
        return this.result;
    }

    public String getVersion() {
        return this.availableVersion;
    }

    public UpdateResult.Type getUpdateResultPriority(int i) {
        switch (i) {
            case 0: {
                return UpdateResult.Type.UPDATE_HIGH;
            }
            case 1: {
                return UpdateResult.Type.UPDATE_MEDIUM;
            }
        }
        return UpdateResult.Type.UPDATE_LOW;
    }
}

