/*
 * Decompiled with CFR 0.152.
 */
package com.tcoded.nochatreports.nms;

import com.tcoded.nochatreports.nms.NmsVersion;
import com.tcoded.nochatreports.nms.channel.ChannelInjector;
import com.tcoded.nochatreports.nms.channel.GlobalPacketHandler;
import com.tcoded.nochatreports.nms.types.NmsProviderConfig;
import com.tcoded.nochatreports.nms.wrapper.PlayerChatPacket;
import com.tcoded.nochatreports.nms.wrapper.SystemChatPacket;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import org.bukkit.entity.Player;

public abstract class NmsProvider<T> {
    private final NmsProviderConfig config;

    public static NmsProvider getNmsProvider(String minecraftVersion, NmsProviderConfig config) {
        try {
            String versionName = NmsVersion.getNmsVersion(minecraftVersion).name();
            Class<?> providerName = Class.forName(NmsProvider.class.getPackageName() + "." + versionName + ".NmsProviderImpl");
            Constructor<?> constructor = providerName.getConstructor(NmsProviderConfig.class);
            return (NmsProvider)constructor.newInstance(config);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public NmsProvider(NmsProviderConfig config) {
        this.config = config;
    }

    public abstract PlayerChatPacket wrapChatPacket(ByteBuf var1);

    public abstract void sendSystemPacket(Player var1, SystemChatPacket var2);

    public abstract T getNmsPlayer(Player var1);

    public abstract GlobalPacketHandler getGlobalPacketHandler();

    public abstract ChannelInjector getChannelInjector();

    public abstract void registerListeners();

    public abstract PlayerChatPacket wrapChatPacket(Object var1);

    public NmsProviderConfig getConfig() {
        return this.config;
    }

    public boolean isDebug() {
        return this.config.debugStateSupplier().get();
    }
}

