/*
 * Decompiled with CFR 0.152.
 */
package com.tcoded.nochatreports.nms.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import java.util.function.Function;

public class MIMList<T>
implements List<T> {
    private final List<T> parent;
    private final Function<T, T> addFunction;
    private final Consumer<T> removeFunction;

    public MIMList(List<T> parent, Function<T, T> addFunction, Consumer<T> removeFunction) {
        this.parent = parent;
        this.addFunction = addFunction == null ? t -> t : addFunction;
        this.removeFunction = removeFunction == null ? t -> {} : removeFunction;
    }

    @Override
    public int size() {
        return this.parent.size();
    }

    @Override
    public boolean isEmpty() {
        return this.parent.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.parent.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.parent.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.parent.toArray();
    }

    @Override
    public boolean add(T o) {
        return this.parent.add(this.addFunction.apply(o));
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = this.parent.remove(o);
        if (removed) {
            this.removeFunction.accept(o);
        }
        return removed;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        c.forEach(this.addFunction::apply);
        return this.parent.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        c.forEach(this.addFunction::apply);
        return this.parent.addAll(index, c);
    }

    @Override
    public void clear() {
        ArrayList<T> copy = new ArrayList<T>(this.parent);
        this.parent.clear();
        copy.forEach(this.removeFunction);
    }

    @Override
    public T get(int index) {
        return this.parent.get(index);
    }

    @Override
    public T set(int index, T element) {
        return this.parent.set(index, this.addFunction.apply(element));
    }

    @Override
    public void add(int index, T element) {
        this.parent.add(index, this.addFunction.apply(element));
    }

    @Override
    public T remove(int index) {
        T removed = this.parent.remove(index);
        this.removeFunction.accept(removed);
        return removed;
    }

    @Override
    public int indexOf(Object o) {
        return this.parent.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.parent.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.parent.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.parent.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.parent.subList(fromIndex, toIndex);
    }

    @Override
    public boolean retainAll(Collection c) {
        ArrayList<T> copy = new ArrayList<T>(this.parent);
        copy.removeAll(c);
        boolean removed = this.parent.retainAll(c);
        if (removed) {
            copy.forEach(this.removeFunction);
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean removed = this.parent.removeAll(c);
        if (removed) {
            c.forEach(this.removeFunction);
        }
        return removed;
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.parent.containsAll(c);
    }

    @Override
    public <K> K[] toArray(K[] a) {
        return this.parent.toArray(a);
    }
}

