/*
 * Decompiled with CFR 0.152.
 */
package com.tcoded.nochatreports.nms.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Function;

public class MIMQueue<T>
implements Queue<T> {
    private final Queue<T> parent;
    private final Function<T, T> addFunction;
    private final Consumer<T> removeFunction;

    public MIMQueue(Queue<T> parent, Function<T, T> addFunction, Consumer<T> removeFunction) {
        this.parent = parent;
        this.addFunction = addFunction == null ? t -> t : addFunction;
        this.removeFunction = removeFunction == null ? t -> {} : removeFunction;
    }

    @Override
    public int size() {
        return this.parent.size();
    }

    @Override
    public boolean isEmpty() {
        return this.parent.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.parent.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.parent.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.parent.toArray();
    }

    @Override
    public boolean add(T o) {
        return this.parent.add(this.addFunction.apply(o));
    }

    @Override
    public boolean offer(T t) {
        return this.parent.add(this.addFunction.apply(t));
    }

    @Override
    public T remove() {
        T removed = this.parent.remove();
        this.removeFunction.accept(removed);
        return removed;
    }

    @Override
    public T poll() {
        T removed = this.parent.poll();
        if (removed != null) {
            this.removeFunction.accept(removed);
        }
        return removed;
    }

    @Override
    public T element() {
        return this.parent.element();
    }

    @Override
    public T peek() {
        return this.parent.peek();
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = this.parent.remove(o);
        if (removed) {
            this.removeFunction.accept(o);
        }
        return removed;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        c.forEach(this.addFunction::apply);
        return this.parent.addAll(c);
    }

    @Override
    public void clear() {
        ArrayList<T> copy = new ArrayList<T>(this.parent);
        this.parent.clear();
        copy.forEach(this.removeFunction);
    }

    @Override
    public boolean retainAll(Collection c) {
        ArrayList<T> copy = new ArrayList<T>(this.parent);
        copy.removeAll(c);
        boolean removed = this.parent.retainAll(c);
        if (removed) {
            copy.forEach(this.removeFunction);
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean removed = this.parent.removeAll(c);
        if (removed) {
            c.forEach(this.removeFunction);
        }
        return removed;
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.parent.containsAll(c);
    }

    @Override
    public <K> K[] toArray(K[] a) {
        return this.parent.toArray(a);
    }
}

