/*
 * Decompiled with CFR 0.152.
 */
package com.tcoded.nochatreports.nms.v1_19_4.channel;

import com.tcoded.nochatreports.nms.NmsProvider;
import com.tcoded.nochatreports.nms.channel.AbstractChannelInjector;
import com.tcoded.nochatreports.nms.channel.GlobalPacketHandler;
import com.tcoded.nochatreports.nms.types.MIMList;
import com.tcoded.nochatreports.nms.types.MIMQueue;
import com.tcoded.nochatreports.nms.v1_19_4.channel.ChannelPacketHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.util.List;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerConnection;
import org.bukkit.entity.Player;

public class ChannelInjectorImpl
extends AbstractChannelInjector {
    private static final Logger logger = Logger.getLogger("NCR Channel Injector");
    private final NmsProvider<EntityPlayer> nms;

    public ChannelInjectorImpl(NmsProvider<EntityPlayer> nms, GlobalPacketHandler packetHandler) {
        super(packetHandler);
        this.nms = nms;
        try {
            for (Field field : PlayerConnection.class.getDeclaredFields()) {
                if (!field.getType().equals(NetworkManager.class)) continue;
                field.setAccessible(true);
                this.connectionField = field;
                break;
            }
        }
        catch (SecurityException | InaccessibleObjectException e) {
            throw new RuntimeException(e);
        }
        ServerConnection srvConnHandler = MinecraftServer.getServer().ad();
        List connList = srvConnHandler.e();
        Class<?> serverConnectionClass = srvConnHandler.getClass();
        boolean unlockPaperQueue = false;
        for (Field field : serverConnectionClass.getDeclaredFields()) {
            try {
                if (field.getType().isAssignableFrom(List.class)) {
                    if (!ChannelInjectorImpl.isIdentityEq(field, srvConnHandler, connList)) {
                        this.applyMimList(field, srvConnHandler, this::handleNewChannel, this::handleRemoveChannel);
                    } else {
                        this.applyMimList(field, srvConnHandler, this::handleNewConnection, this::handleRemoveConnection);
                    }
                    unlockPaperQueue = true;
                }
                if (!unlockPaperQueue || !field.getType().isAssignableFrom(Queue.class)) continue;
                this.applyMimQueue(field, srvConnHandler);
                unlockPaperQueue = false;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        for (NetworkManager conn : srvConnHandler.e()) {
            this.setPacketHandler(conn, false);
        }
    }

    private static boolean isIdentityEq(Field field, ServerConnection serverConnectionHandler, List<NetworkManager> connectionsList) throws IllegalAccessException {
        field.setAccessible(true);
        return field.get(serverConnectionHandler) == connectionsList;
    }

    private <T> void applyMimList(Field field, ServerConnection handler, Function<T, T> interceptor, Consumer<T> cleanup) {
        try {
            field.setAccessible(true);
            List objectList = (List)field.get(handler);
            field.set(handler, new MIMList<T>(objectList, interceptor, cleanup));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void applyMimQueue(Field field, ServerConnection handler) {
        try {
            field.setAccessible(true);
            Queue pendingQueue = (Queue)field.get(handler);
            field.set(handler, new MIMQueue<NetworkManager>(pendingQueue, this::handleNewConnection, this::handleRemoveConnection));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private NetworkManager handleNewConnection(NetworkManager connection) {
        this.handleNewChannel(connection.m);
        return connection;
    }

    private Channel handleNewChannel(Channel channel) {
        this.setPacketHandler(channel, false);
        return channel;
    }

    @Override
    public void inject(Player player) {
        PlayerConnection listener = this.nms.getNmsPlayer((Player)player).b;
        NetworkManager connection = this.getConnection(listener);
        this.setPacketHandler(connection, true);
        this.mapPlayerChannel(connection.m.remoteAddress(), player);
    }

    private void setPacketHandler(NetworkManager connection, boolean replace) {
        if (connection.m == null) {
            if (this.nms.isDebug()) {
                logger.info("setPacketHandler: connection.channel is null");
            }
            return;
        }
        this.setPacketHandler(connection.m, replace);
    }

    private void setPacketHandler(Channel channel, boolean replace) {
        if (channel == null) {
            if (this.nms.isDebug()) {
                logger.warning("setPacketHandler failed: channel is null");
            }
            return;
        }
        channel.eventLoop().submit(() -> {
            boolean hasCustomHandler;
            ChannelPipeline pipeline = channel.pipeline();
            boolean bl = hasCustomHandler = pipeline.get("ncr_packet_handler") != null;
            if (hasCustomHandler && replace) {
                pipeline.remove("ncr_packet_handler");
            }
            if (!hasCustomHandler || replace) {
                pipeline.addBefore("packet_handler", "ncr_packet_handler", (ChannelHandler)new ChannelPacketHandler(this.getGlobalPacketHandler()));
            }
        });
    }

    @Override
    public void uninject(Player player) {
        PlayerConnection listener = this.nms.getNmsPlayer((Player)player).b;
        NetworkManager connection = this.getConnection(listener);
        this.handleRemoveConnection(connection);
        this.unmapPlayerChannel(connection.m.remoteAddress());
    }

    private void handleRemoveConnection(NetworkManager connection) {
        if (connection.m == null) {
            return;
        }
        this.handleRemoveChannel(connection.m);
    }

    private void handleRemoveChannel(Channel channel) {
        if (channel == null) {
            if (this.nms.getConfig().isPaper()) {
                logger.warning("handleRemoveChannel channel is null");
            }
            return;
        }
        channel.eventLoop().submit(() -> channel.pipeline().remove("ncr_packet_handler"));
    }

    private NetworkManager getConnection(PlayerConnection listener) {
        if (listener == null) {
            return null;
        }
        try {
            return (NetworkManager)this.connectionField.get(listener);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

