/*
 * Decompiled with CFR 0.152.
 */
package com.tcoded.nochatreports.nms.v1_21_9.wrapper;

import com.tcoded.nochatreports.nms.v1_21_9.wrapper.SystemChatPacketImpl;
import com.tcoded.nochatreports.nms.wrapper.PlayerChatPacket;
import com.tcoded.nochatreports.nms.wrapper.SystemChatPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.server.MinecraftServer;

public class PlayerChatPacketImpl
implements PlayerChatPacket {
    private final ClientboundPlayerChatPacket packet;

    public PlayerChatPacketImpl(ClientboundPlayerChatPacket packet) {
        this.packet = packet;
    }

    public PlayerChatPacketImpl(ByteBuf byteBuf) {
        this((ClientboundPlayerChatPacket)ClientboundPlayerChatPacket.STREAM_CODEC.decode((Object)new RegistryFriendlyByteBuf(byteBuf, (RegistryAccess)MinecraftServer.getServer().registryAccess())));
    }

    @Override
    public SystemChatPacket toSystem() {
        try {
            ChatType.Bound chatTypeWithBound = this.packet.chatType();
            Component content = this.packet.unsignedContent();
            if (content == null) {
                content = Component.literal((String)this.packet.body().content());
            }
            Component formattedContent = chatTypeWithBound.decorate(content);
            ClientboundSystemChatPacket systemChatPacket = new ClientboundSystemChatPacket(formattedContent, false);
            return new SystemChatPacketImpl(systemChatPacket);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

