/*
 * Decompiled with CFR 0.152.
 */
package com.tcoded.nochatreports.plugin.listener;

import java.lang.reflect.Method;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerKickEvent;

public class KickListener
implements Listener {
    private final String preventedKickMessage;
    private final String[] invalidReasons;

    public KickListener(String preventedKickMessage, List<String> invalidReasons) {
        this.preventedKickMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)preventedKickMessage);
        this.invalidReasons = (String[])invalidReasons.toArray(String[]::new);
    }

    @EventHandler
    public void onKick(PlayerKickEvent event) {
        try {
            Class<?> kickClass = event.getClass();
            Method getCause = kickClass.getMethod("getCause", new Class[0]);
            Enum cause = (Enum)getCause.invoke((Object)event, new Object[0]);
            String paperReason = cause.name();
            for (String invalidReason : this.invalidReasons) {
                if (!paperReason.equals(invalidReason)) continue;
                event.setCancelled(true);
                event.getPlayer().sendMessage(this.preventedKickMessage);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String reason = event.getReason();
        if (reason.equals("Received chat packet with missing or invalid signature.")) {
            event.getPlayer().sendMessage(this.preventedKickMessage);
            event.setCancelled(true);
        }
    }
}

