/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal;

import com.mojang.logging.LogUtils;
import net.cassiokf.industrialrenewal.ber.BERBatteryBank;
import net.cassiokf.industrialrenewal.ber.BERDamGenerator;
import net.cassiokf.industrialrenewal.ber.BERDamTurbine;
import net.cassiokf.industrialrenewal.ber.BEREnergyCableMeter;
import net.cassiokf.industrialrenewal.ber.BEREnergyLevel;
import net.cassiokf.industrialrenewal.ber.BERFluidGauge;
import net.cassiokf.industrialrenewal.ber.BERFluidPipeGauge;
import net.cassiokf.industrialrenewal.ber.BERFluidTank;
import net.cassiokf.industrialrenewal.ber.BERIndustrialBatteryBank;
import net.cassiokf.industrialrenewal.ber.BERMining;
import net.cassiokf.industrialrenewal.ber.BERPortableGenerator;
import net.cassiokf.industrialrenewal.ber.BERSolarPanelFrame;
import net.cassiokf.industrialrenewal.ber.BERSteamBoiler;
import net.cassiokf.industrialrenewal.ber.BERSteamTurbine;
import net.cassiokf.industrialrenewal.ber.BERTransformerHV;
import net.cassiokf.industrialrenewal.ber.BERWindTurbineHead;
import net.cassiokf.industrialrenewal.ber.BERWindTurbinePillar;
import net.cassiokf.industrialrenewal.ber.BERWire;
import net.cassiokf.industrialrenewal.fluid.ModFluidTypes;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.init.ModBlocks;
import net.cassiokf.industrialrenewal.init.ModFluids;
import net.cassiokf.industrialrenewal.init.ModItems;
import net.cassiokf.industrialrenewal.tab.ModCreativeTabs;
import net.cassiokf.industrialrenewal.util.Utils;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="industrialrenewal")
public class IndustrialRenewal {
    public static final String MODID = "industrialrenewal";
    public static final Logger LOGGER = LogUtils.getLogger();

    public IndustrialRenewal() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModCreativeTabs.register(modEventBus);
        ModBlockEntity.registerInit(modEventBus);
        ModFluids.register(modEventBus);
        ModFluidTypes.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="industrialrenewal", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.STEAM.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.STEAM_FLOWING.get()), (RenderType)RenderType.m_110466_());
        }

        @SubscribeEvent
        public static void initClient(EntityRenderersEvent.RegisterRenderers event) {
            Utils.sendConsoleMessage("Industrial Renewal == Registering BlockEntityRenderer");
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntity.BATTERY_BANK.get(), BERBatteryBank::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntity.SOLAR_PANEL_FRAME.get(), BERSolarPanelFrame::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntity.ENERGY_LEVEL.get(), BEREnergyLevel::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntity.FLUID_GAUGE.get(), BERFluidGauge::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntity.ISOLATOR_TILE.get(), BERWire::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntity.TRANSFORMER_TILE.get(), BERTransformerHV::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntity.INDUSTRIAL_BATTERY_TILE.get(), BERIndustrialBatteryBank::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntity.FLUID_TANK_TILE.get(), BERFluidTank::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntity.DAM_TURBINE_TILE.get(), BERDamTurbine::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntity.DAM_GENERATOR.get(), BERDamGenerator::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntity.STEAM_BOILER_TILE.get(), BERSteamBoiler::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntity.PORTABLE_GENERATOR_TILE.get(), BERPortableGenerator::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntity.STEAM_TURBINE_TILE.get(), BERSteamTurbine::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntity.MINER_TILE.get(), BERMining::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntity.TURBINE_PILLAR_TILE.get(), BERWindTurbinePillar::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntity.WIND_TURBINE_TILE.get(), BERWindTurbineHead::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntity.ENERGYCABLE_LV_METER_TILE.get(), BEREnergyCableMeter::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntity.ENERGYCABLE_MV_METER_TILE.get(), BEREnergyCableMeter::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntity.ENERGYCABLE_HV_METER_TILE.get(), BEREnergyCableMeter::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntity.FLUIDPIPE_GAUGE_TILE.get(), BERFluidPipeGauge::new);
            Utils.sendConsoleMessage("Industrial Renewal == Done Registering BlockEntityRenderer");
        }
    }
}

