/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.block;

import net.cassiokf.industrialrenewal.block.abstracts.BlockAbstractHorizontalFacing;
import net.cassiokf.industrialrenewal.blockentity.BlockEntityBatteryBank;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.item.ItemScrewdriver;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class BlockBatteryBank
extends BlockAbstractHorizontalFacing
implements EntityBlock {
    public static BooleanProperty NORTH_OUTPUT = BooleanProperty.m_61465_((String)"north_out");
    public static BooleanProperty SOUTH_OUTPUT = BooleanProperty.m_61465_((String)"south_out");
    public static BooleanProperty EAST_OUTPUT = BooleanProperty.m_61465_((String)"east_out");
    public static BooleanProperty WEST_OUTPUT = BooleanProperty.m_61465_((String)"west_out");
    public static BooleanProperty UP_OUTPUT = BooleanProperty.m_61465_((String)"up_out");
    public static BooleanProperty DOWN_OUTPUT = BooleanProperty.m_61465_((String)"down_out");

    public BlockBatteryBank(BlockBehaviour.Properties props) {
        super(props.m_60955_());
    }

    public BlockBatteryBank() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60978_(1.0f).m_60955_().m_60918_(SoundType.f_56743_).m_222994_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)NORTH_OUTPUT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH_OUTPUT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST_OUTPUT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST_OUTPUT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP_OUTPUT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN_OUTPUT, (Comparable)Boolean.valueOf(false)));
    }

    public Object getRenderPropertiesInternal() {
        return super.getRenderPropertiesInternal();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NORTH_OUTPUT, SOUTH_OUTPUT, EAST_OUTPUT, WEST_OUTPUT, UP_OUTPUT, DOWN_OUTPUT});
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntityBatteryBank tile;
        ItemStack heldItem = pPlayer.m_21120_(pHand);
        if (pHand.equals((Object)InteractionHand.MAIN_HAND) && heldItem.m_41720_() instanceof ItemScrewdriver && (tile = (BlockEntityBatteryBank)pLevel.m_7702_(pPos)) != null) {
            Direction side = pHit.m_82434_();
            boolean change = tile.toggleFacing(side);
            pState = (BlockState)pState.m_61124_((Property)this.toggleOutput(side), (Comparable)Boolean.valueOf(change));
            pLevel.m_46597_(pPos, pState);
            if (pLevel.m_5776_()) {
                ItemScrewdriver.playSound(pLevel, pPos);
            }
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public BooleanProperty toggleOutput(Direction facing) {
        switch (facing) {
            case NORTH: {
                return NORTH_OUTPUT;
            }
            case SOUTH: {
                return SOUTH_OUTPUT;
            }
            case EAST: {
                return EAST_OUTPUT;
            }
            case WEST: {
                return WEST_OUTPUT;
            }
            case UP: {
                return UP_OUTPUT;
            }
            case DOWN: {
                return DOWN_OUTPUT;
            }
        }
        return NORTH_OUTPUT;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntity.BATTERY_BANK.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : ($0, $1, $2, blockEntity) -> ((BlockEntityBatteryBank)blockEntity).tick();
    }
}

