/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.block.abstracts;

import net.cassiokf.industrialrenewal.block.abstracts.BlockConnectedMultiblocks;
import net.cassiokf.industrialrenewal.block.decor.BlockIndustrialFloor;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntityMultiBlocksTube;
import net.cassiokf.industrialrenewal.init.ModBlocks;
import net.cassiokf.industrialrenewal.init.ModItems;
import net.cassiokf.industrialrenewal.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BlockPipeBase<TE extends BlockEntityMultiBlocksTube>
extends BlockConnectedMultiblocks<TE> {
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty FLOOR = BooleanProperty.m_61465_((String)"floor");
    public static final BooleanProperty UPFLOOR = BooleanProperty.m_61465_((String)"upfloor");
    public static final BooleanProperty CSOUTH = BooleanProperty.m_61465_((String)"c_south");
    public static final BooleanProperty CNORTH = BooleanProperty.m_61465_((String)"c_north");
    public static final BooleanProperty CEAST = BooleanProperty.m_61465_((String)"c_east");
    public static final BooleanProperty CWEST = BooleanProperty.m_61465_((String)"c_west");
    public static final BooleanProperty CUP = BooleanProperty.m_61465_((String)"c_up");
    public static final BooleanProperty CDOWN = BooleanProperty.m_61465_((String)"c_down");
    private static float NORTHZ1 = 0.25f;
    private static float SOUTHZ2 = 0.75f;
    private static float WESTX1 = 0.25f;
    private static float EASTX2 = 0.75f;
    private static double UP2 = 16.0;
    private static double DOWN1 = 0.0;
    public float nodeWidth;
    public float nodeHeight;

    public BlockPipeBase(BlockBehaviour.Properties property, float nodeWidth, float nodeHeight) {
        super(property);
        this.nodeWidth = nodeWidth;
        this.nodeHeight = nodeHeight;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FLOOR, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UPFLOOR, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CSOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CNORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CEAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CWEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CUP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CDOWN, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isMaster(Level world, BlockPos pos) {
        BlockEntityMultiBlocksTube te = (BlockEntityMultiBlocksTube)world.m_7702_(pos);
        return te != null && te.isMaster();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, SOUTH, EAST, WEST, UP, DOWN, FLOOR, UPFLOOR, CSOUTH, CNORTH, CEAST, CWEST, CUP, CDOWN});
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hitResult) {
        BlockEntity be;
        ItemStack playerStack = player.m_21120_(handIn);
        if (!worldIn.f_46443_ && (be = worldIn.m_7702_(pos)) instanceof BlockEntityMultiBlocksTube) {
            BlockEntityMultiBlocksTube bet = (BlockEntityMultiBlocksTube)be;
            Utils.sendChatMessage(player, "Valid outputs: " + ((BlockEntityMultiBlocksTube)((Object)bet.getMaster())).getReceiversContainers().size());
        }
        if (playerStack.m_41720_().equals(((BlockIndustrialFloor)((Object)ModBlocks.INDUSTRIAL_FLOOR.get())).m_5456_()) && !((Boolean)state.m_61143_((Property)FLOOR)).booleanValue()) {
            state = (BlockState)state.m_61124_((Property)FLOOR, (Comparable)Boolean.valueOf(true));
            BlockState stateAbove = worldIn.m_8055_(pos.m_7494_());
            if (stateAbove.m_60734_() instanceof BlockPipeBase) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)UPFLOOR, (Comparable)((Boolean)stateAbove.m_61143_((Property)FLOOR))), 3);
            } else {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)UPFLOOR, (Comparable)Boolean.valueOf(false)), 3);
            }
            if (!player.m_7500_()) {
                playerStack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (playerStack.m_41720_().equals(ModItems.SCREW_DRIVER.get()) && ((Boolean)state.m_61143_((Property)FLOOR)).booleanValue()) {
            state = (BlockState)state.m_61124_((Property)FLOOR, (Comparable)Boolean.valueOf(false));
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)UPFLOOR, (Comparable)Boolean.valueOf(false)), 3);
            Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModBlocks.INDUSTRIAL_FLOOR.get()));
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hitResult);
    }

    @Override
    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.f_46443_) {
            for (Direction direction : Direction.values()) {
                worldIn.m_7731_(pos, (BlockState)worldIn.m_8055_(pos).m_61124_((Property)this.directionToBooleanProp(direction), (Comparable)Boolean.valueOf(this.canConnectToPipe((BlockGetter)worldIn, pos, direction))), 3);
                worldIn.m_7731_(pos, (BlockState)worldIn.m_8055_(pos).m_61124_((Property)this.directionToBooleanPropCap(direction), (Comparable)Boolean.valueOf(this.canConnectToCapability((BlockGetter)worldIn, pos, direction))), 3);
            }
            BlockEntity be = worldIn.m_7702_(pos);
            if (be instanceof BlockEntityMultiBlocksTube) {
                BlockEntityMultiBlocksTube mb = (BlockEntityMultiBlocksTube)be;
                mb.checkForOutPuts(fromPos);
            }
        }
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    @Override
    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean flag) {
        if (!state.m_60713_(oldState.m_60734_())) {
            BlockEntity blockentity = world.m_7702_(pos);
            if (blockentity instanceof BlockEntityMultiBlocksTube) {
                ((BlockEntityMultiBlocksTube)blockentity).breakBlock();
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, oldState, flag);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        NORTHZ1 = this.isConnected(worldIn, pos, Direction.NORTH) ? 0.0f : 8.0f - this.nodeWidth / 2.0f;
        SOUTHZ2 = this.isConnected(worldIn, pos, Direction.SOUTH) ? 16.0f : 8.0f + this.nodeWidth / 2.0f;
        WESTX1 = this.isConnected(worldIn, pos, Direction.WEST) ? 0.0f : 8.0f - this.nodeWidth / 2.0f;
        EASTX2 = this.isConnected(worldIn, pos, Direction.EAST) ? 16.0f : 8.0f + this.nodeWidth / 2.0f;
        DOWN1 = this.isConnected(worldIn, pos, Direction.DOWN) ? 0.0 : (double)(8.0f - this.nodeWidth / 2.0f);
        UP2 = this.isConnected(worldIn, pos, Direction.UP) ? 16.0 : (double)(8.0f + this.nodeWidth / 2.0f);
        return Block.m_49796_((double)WESTX1, (double)DOWN1, (double)NORTHZ1, (double)EASTX2, (double)UP2, (double)SOUTHZ2);
    }

    public boolean m_7420_(BlockState p_49928_, BlockGetter p_49929_, BlockPos p_49930_) {
        return true;
    }

    public final boolean isConnected(BlockGetter worldIn, BlockPos pos, Direction facing) {
        if (worldIn.m_8055_(pos).m_60734_() instanceof BlockPipeBase) {
            BlockState state = worldIn.m_8055_(pos);
            return (Boolean)state.m_61143_((Property)this.directionToBooleanProp(facing)) != false || (Boolean)state.m_61143_((Property)this.directionToBooleanPropCap(facing)) != false;
        }
        return false;
    }

    public BooleanProperty directionToBooleanProp(Direction d) {
        return switch (d) {
            case Direction.UP -> UP;
            case Direction.DOWN -> DOWN;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
            case Direction.SOUTH -> SOUTH;
            default -> NORTH;
        };
    }

    public BooleanProperty directionToBooleanPropCap(Direction d) {
        return switch (d) {
            case Direction.UP -> CUP;
            case Direction.DOWN -> CDOWN;
            case Direction.EAST -> CEAST;
            case Direction.WEST -> CWEST;
            case Direction.SOUTH -> CSOUTH;
            default -> CNORTH;
        };
    }

    public abstract boolean canConnectToPipe(BlockGetter var1, BlockPos var2, Direction var3);

    public abstract boolean canConnectToCapability(BlockGetter var1, BlockPos var2, Direction var3);
}

