/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.block.decor;

import net.cassiokf.industrialrenewal.block.abstracts.BlockAbstractFourConnections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockBrace
extends BlockAbstractFourConnections {
    public static final EnumProperty<EnumOrientation> FACING = EnumProperty.m_61587_((String)"facing", EnumOrientation.class);

    public BlockBrace() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60978_(1.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    protected boolean isValidConnection(BlockState neighborState, BlockGetter world, BlockPos ownPos, Direction neighborDirection) {
        Block nb = neighborState.m_60734_();
        return nb instanceof BlockBrace;
    }

    @Override
    public boolean canConnectTo(Level worldIn, BlockPos currentPos, Direction neighborDirection) {
        BlockPos neighborPos = currentPos.m_121945_(neighborDirection);
        BlockState neighborState = worldIn.m_8055_(neighborPos);
        return this.isValidConnection(neighborState, (BlockGetter)worldIn, currentPos, neighborDirection);
    }

    public VoxelShape m_7947_(BlockState p_230335_1_, BlockGetter p_230335_2_, BlockPos p_230335_3_) {
        return NULL_SHAPE;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        for (Direction face : Direction.Plane.HORIZONTAL) {
            if (EnumOrientation.forFacings(context.m_43719_(), context.m_8125_()).getName().contains("down")) {
                state = (BlockState)state.m_61124_((Property)this.getPropertyBasedOnDirection(face.m_122424_()), (Comparable)Boolean.valueOf(this.canConnectTo(context.m_43725_(), context.m_8083_(), face)));
                continue;
            }
            state = (BlockState)state.m_61124_((Property)this.getPropertyBasedOnDirection(face), (Comparable)Boolean.valueOf(this.canConnectTo(context.m_43725_(), context.m_8083_(), face)));
        }
        return (BlockState)state.m_61124_(FACING, (Comparable)((Object)EnumOrientation.forFacings(context.m_43719_(), context.m_8125_())));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighborPos, boolean flag) {
        for (Direction face : Direction.Plane.HORIZONTAL) {
            if (((EnumOrientation)((Object)state.m_61143_(FACING))).getName().contains("down")) {
                state = (BlockState)state.m_61124_((Property)this.getPropertyBasedOnDirection(face.m_122424_()), (Comparable)Boolean.valueOf(this.canConnectTo(level, pos, face)));
                continue;
            }
            state = (BlockState)state.m_61124_((Property)this.getPropertyBasedOnDirection(face), (Comparable)Boolean.valueOf(this.canConnectTo(level, pos, face)));
        }
        level.m_7731_(pos, state, 2);
    }

    public static enum EnumOrientation implements StringRepresentable
    {
        DOWN_EAST(0, "down_east", Direction.DOWN),
        EAST(1, "east", Direction.EAST),
        WEST(2, "west", Direction.WEST),
        SOUTH(3, "south", Direction.SOUTH),
        NORTH(4, "north", Direction.NORTH),
        DOWN_WEST(5, "down_west", Direction.DOWN),
        DOWN_SOUTH(6, "down_south", Direction.DOWN),
        DOWN_NORTH(7, "down_north", Direction.DOWN);

        private static final EnumOrientation[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final Direction facing;

        private EnumOrientation(int meta, String name, Direction facing) {
            this.meta = meta;
            this.name = name;
            this.facing = facing;
        }

        public static EnumOrientation byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public static EnumOrientation forFacings(Direction clickedSide, Direction entityFacing) {
            switch (clickedSide) {
                case DOWN: 
                case UP: {
                    switch (entityFacing) {
                        case EAST: {
                            return DOWN_EAST;
                        }
                        case NORTH: {
                            return DOWN_NORTH;
                        }
                        case SOUTH: {
                            return DOWN_SOUTH;
                        }
                        case WEST: {
                            return DOWN_WEST;
                        }
                    }
                    throw new IllegalArgumentException("Invalid entityFacing " + String.valueOf(entityFacing) + " for facing " + String.valueOf(clickedSide));
                }
                case NORTH: {
                    return SOUTH;
                }
                case SOUTH: {
                    return NORTH;
                }
                case WEST: {
                    return EAST;
                }
                case EAST: {
                    return WEST;
                }
            }
            throw new IllegalArgumentException("Invalid facing: " + String.valueOf(clickedSide));
        }

        public int getMetadata() {
            return this.meta;
        }

        public Direction getFacing() {
            return this.facing;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumOrientation[EnumOrientation.values().length];
            EnumOrientation[] enumOrientationArray = EnumOrientation.values();
            int n = enumOrientationArray.length;
            for (int i = 0; i < n; ++i) {
                EnumOrientation blockbrace$enumorientation;
                EnumOrientation.META_LOOKUP[blockbrace$enumorientation.getMetadata()] = blockbrace$enumorientation = enumOrientationArray[i];
            }
        }
    }
}

