/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.block.decor;

import net.cassiokf.industrialrenewal.block.abstracts.BlockAbstractHorizontalFacingWithActivating;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockCatwalkGate
extends BlockAbstractHorizontalFacingWithActivating {
    protected static final VoxelShape RNORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape RSOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape RWEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    protected static final VoxelShape REAST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)24.0, (double)1.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)24.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)24.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)24.0, (double)16.0);

    public BlockCatwalkGate(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockCatwalkGate() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60978_(1.0f));
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Vec3 hit = context.m_43720_();
        Vec3 hitQuad = hit.m_82546_(Vec3.m_82512_((Vec3i)context.m_8083_()));
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)this.quadToDir(hitQuad));
    }

    public Direction quadToDir(Vec3 vector3d) {
        if (vector3d.f_82481_ > vector3d.f_82479_ && vector3d.f_82481_ > -vector3d.f_82479_) {
            return Direction.SOUTH;
        }
        if (vector3d.f_82481_ < vector3d.f_82479_ && vector3d.f_82481_ < -vector3d.f_82479_) {
            return Direction.NORTH;
        }
        if (vector3d.f_82481_ > vector3d.f_82479_ && vector3d.f_82481_ < -vector3d.f_82479_) {
            return Direction.WEST;
        }
        if (vector3d.f_82481_ < vector3d.f_82479_ && vector3d.f_82481_ > -vector3d.f_82479_) {
            return Direction.EAST;
        }
        return Direction.NORTH;
    }

    public boolean collisionExtendsVertically(BlockState state, BlockGetter level, BlockPos pos, Entity collidingEntity) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction face = (Direction)state.m_61143_((Property)FACING);
        if (face == Direction.NORTH) {
            return RNORTH_AABB;
        }
        if (face == Direction.SOUTH) {
            return RSOUTH_AABB;
        }
        if (face == Direction.WEST) {
            return RWEST_AABB;
        }
        if (face == Direction.EAST) {
            return REAST_AABB;
        }
        return RNORTH_AABB;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Boolean open = (Boolean)state.m_61143_((Property)ACTIVE);
        VoxelShape FINAL_SHAPE = NULL_SHAPE;
        Direction face = (Direction)state.m_61143_((Property)FACING);
        if (!open.booleanValue()) {
            FINAL_SHAPE = face == Direction.NORTH ? Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)NORTH_AABB) : (face == Direction.SOUTH ? Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)SOUTH_AABB) : (face == Direction.WEST ? Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)WEST_AABB) : Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)EAST_AABB)));
        }
        return FINAL_SHAPE;
    }
}

