/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.block.decor;

import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.block.abstracts.BlockAbstractHorizontalFacing;
import net.cassiokf.industrialrenewal.block.decor.BlockCatwalk;
import net.cassiokf.industrialrenewal.init.ModBlocks;
import net.cassiokf.industrialrenewal.init.ModItems;
import net.cassiokf.industrialrenewal.item.decor.ItemBlockCatwalk;
import net.cassiokf.industrialrenewal.item.decor.ItemBlockCatwalkStair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockCatwalkStair
extends BlockAbstractHorizontalFacing {
    public static final BooleanProperty ACTIVE_LEFT = BooleanProperty.m_61465_((String)"active_left");
    public static final BooleanProperty ACTIVE_RIGHT = BooleanProperty.m_61465_((String)"active_right");
    protected static final VoxelShape BASE_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NC_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)0.5);
    protected static final VoxelShape SC_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)32.0, (double)16.0);
    protected static final VoxelShape WC_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)32.0, (double)16.0);
    protected static final VoxelShape EC_AABB = Block.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
    protected static final VoxelShape RNC_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.5);
    protected static final VoxelShape RSC_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape RWC_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0);
    protected static final VoxelShape REC_AABB = Block.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public BlockCatwalkStair(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockCatwalkStair() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60978_(1.0f));
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        if (!context.m_43723_().m_6047_()) {
            return context.m_43722_().m_41720_() instanceof ItemBlockCatwalkStair || context.m_43722_().m_41720_() instanceof ItemBlockCatwalk;
        }
        return super.m_6864_(state, context);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hitResult) {
        if (!worldIn.f_46443_ && handIn == InteractionHand.MAIN_HAND) {
            BlockCatwalkStair catwalk_stair;
            Item playerItem = player.m_21205_().m_41720_();
            if (playerItem.equals(ModItems.SCREW_DRIVER.get())) {
                state = (BlockState)state.m_61122_((Property)FACING);
                worldIn.m_46597_(pos, state);
                return InteractionResult.SUCCESS;
            }
            BlockPos posOffset = pos.m_121945_((Direction)state.m_61143_((Property)FACING)).m_7494_();
            BlockState stateOffset = worldIn.m_8055_(posOffset);
            BlockCatwalkStair blockCatwalkStair = playerItem.equals(((BlockCatwalkStair)((Object)ModBlocks.CATWALK_STAIR.get())).m_5456_()) ? (BlockCatwalkStair)((Object)ModBlocks.CATWALK_STAIR.get()) : (catwalk_stair = playerItem.equals(((BlockCatwalkStair)((Object)ModBlocks.CATWALK_STAIR_STEEL.get())).m_5456_()) ? (BlockCatwalkStair)((Object)ModBlocks.CATWALK_STAIR_STEEL.get()) : null);
            BlockCatwalk blockCatwalk = playerItem.equals(((BlockCatwalk)((Object)ModBlocks.CATWALK.get())).m_5456_()) ? (BlockCatwalk)((Object)ModBlocks.CATWALK.get()) : (playerItem.equals(((BlockCatwalk)((Object)ModBlocks.CATWALK_STEEL.get())).m_5456_()) ? (BlockCatwalk)((Object)ModBlocks.CATWALK_STEEL.get()) : null);
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ACTIVE_LEFT, ACTIVE_RIGHT});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_8125_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
        return (BlockState)((BlockState)state.m_61124_((Property)ACTIVE_LEFT, (Comparable)this.sideConnected(state, context.m_43725_(), context.m_8083_(), facing.m_122428_()))).m_61124_((Property)ACTIVE_RIGHT, (Comparable)this.sideConnected(state, context.m_43725_(), context.m_8083_(), facing.m_122427_()));
    }

    public BlockState getStateForPlacement(Level level, BlockPos pos, Direction facing) {
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
        return (BlockState)((BlockState)state.m_61124_((Property)ACTIVE_LEFT, (Comparable)this.sideConnected(state, level, pos, facing.m_122428_()))).m_61124_((Property)ACTIVE_RIGHT, (Comparable)this.sideConnected(state, level, pos, facing.m_122427_()));
    }

    private Boolean sideConnected(BlockState state, Level world, BlockPos pos, Direction direction) {
        Direction face = (Direction)state.m_61143_((Property)FACING);
        BlockPos posOffset = pos.m_121945_(direction);
        BlockState stateOffset = world.m_8055_(posOffset);
        if (stateOffset.m_60734_() instanceof BlockCatwalkStair) {
            Direction sideStairFace = (Direction)stateOffset.m_61143_((Property)FACING);
            return sideStairFace != face;
        }
        return true;
    }

    public boolean collisionExtendsVertically(BlockState state, BlockGetter level, BlockPos pos, Entity collidingEntity) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        VoxelShape FINAL_SHAPE = BASE_AABB;
        Direction face = (Direction)state.m_61143_((Property)FACING);
        Boolean left = (Boolean)state.m_61143_((Property)ACTIVE_LEFT);
        Boolean right = (Boolean)state.m_61143_((Property)ACTIVE_RIGHT);
        if (face == Direction.NORTH) {
            FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)NORTH_AABB);
        }
        if (face == Direction.SOUTH) {
            FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)SOUTH_AABB);
        }
        if (face == Direction.WEST) {
            FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)WEST_AABB);
        }
        if (face == Direction.EAST) {
            FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)EAST_AABB);
        }
        return FINAL_SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getVoxelShape(state, false);
    }

    private VoxelShape getVoxelShape(BlockState state, boolean isForRender) {
        VoxelShape FINAL_SHAPE = BASE_AABB;
        Direction face = (Direction)state.m_61143_((Property)FACING);
        Boolean left = (Boolean)state.m_61143_((Property)ACTIVE_LEFT);
        Boolean right = (Boolean)state.m_61143_((Property)ACTIVE_RIGHT);
        if (face == Direction.NORTH) {
            FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)NORTH_AABB);
            if (left.booleanValue()) {
                FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)(isForRender ? RWC_AABB : WC_AABB));
            }
            if (right.booleanValue()) {
                FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)(isForRender ? REC_AABB : EC_AABB));
            }
        }
        if (face == Direction.SOUTH) {
            FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)SOUTH_AABB);
            if (left.booleanValue()) {
                FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)(isForRender ? REC_AABB : EC_AABB));
            }
            if (right.booleanValue()) {
                FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)(isForRender ? RWC_AABB : WC_AABB));
            }
        }
        if (face == Direction.WEST) {
            FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)WEST_AABB);
            if (left.booleanValue()) {
                FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)(isForRender ? RSC_AABB : SC_AABB));
            }
            if (right.booleanValue()) {
                FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)(isForRender ? RNC_AABB : NC_AABB));
            }
        }
        if (face == Direction.EAST) {
            FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)EAST_AABB);
            if (left.booleanValue()) {
                FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)(isForRender ? RNC_AABB : NC_AABB));
            }
            if (right.booleanValue()) {
                FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)(isForRender ? RSC_AABB : SC_AABB));
            }
        }
        return FINAL_SHAPE;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos neighbor, boolean flag) {
        state = (BlockState)((BlockState)state.m_61124_((Property)ACTIVE_LEFT, (Comparable)this.sideConnected(state, world, pos, ((Direction)state.m_61143_((Property)FACING)).m_122428_()))).m_61124_((Property)ACTIVE_RIGHT, (Comparable)this.sideConnected(state, world, pos, ((Direction)state.m_61143_((Property)FACING)).m_122427_()));
        world.m_7731_(pos, state, 2);
        super.m_6861_(state, world, pos, block, neighbor, flag);
    }
}

