/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.block.decor;

import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.block.abstracts.BlockAbstractHorizontalFacing;
import net.cassiokf.industrialrenewal.init.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockHandRail
extends BlockAbstractHorizontalFacing {
    protected static final VoxelShape RNORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape RSOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape RWEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    protected static final VoxelShape REAST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)24.0, (double)1.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)24.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)24.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)24.0, (double)16.0);

    public BlockHandRail(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockHandRail() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60978_(1.0f));
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Vec3 hit = context.m_43720_();
        Vec3 hitQuad = hit.m_82546_(Vec3.m_82512_((Vec3i)context.m_8083_()));
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)this.quadToDir(hitQuad));
    }

    public Direction quadToDir(Vec3 vector3d) {
        if (vector3d.f_82481_ > vector3d.f_82479_ && vector3d.f_82481_ > -vector3d.f_82479_) {
            return Direction.SOUTH;
        }
        if (vector3d.f_82481_ < vector3d.f_82479_ && vector3d.f_82481_ < -vector3d.f_82479_) {
            return Direction.NORTH;
        }
        if (vector3d.f_82481_ > vector3d.f_82479_ && vector3d.f_82481_ < -vector3d.f_82479_) {
            return Direction.WEST;
        }
        if (vector3d.f_82481_ < vector3d.f_82479_ && vector3d.f_82481_ > -vector3d.f_82479_) {
            return Direction.EAST;
        }
        return Direction.NORTH;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hitResult) {
        if (!worldIn.f_46443_) {
            if (handIn == InteractionHand.MAIN_HAND) {
                Item playerItem = player.m_21205_().m_41720_();
                if (playerItem.equals(ModItems.SCREW_DRIVER.get())) {
                    state = (BlockState)state.m_61122_((Property)FACING);
                    worldIn.m_7731_(pos, state, 2);
                    return InteractionResult.SUCCESS;
                }
            } else {
                return InteractionResult.PASS;
            }
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getVoxelShape(state, true);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getVoxelShape(state, false);
    }

    private VoxelShape getVoxelShape(BlockState state, boolean isForRender) {
        Direction face = (Direction)state.m_61143_((Property)FACING);
        if (face == Direction.NORTH) {
            return isForRender ? RNORTH_AABB : NORTH_AABB;
        }
        if (face == Direction.SOUTH) {
            return isForRender ? RSOUTH_AABB : SOUTH_AABB;
        }
        if (face == Direction.WEST) {
            return isForRender ? RWEST_AABB : WEST_AABB;
        }
        return isForRender ? REAST_AABB : EAST_AABB;
    }
}

