/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.block.transport;

import net.cassiokf.industrialrenewal.block.abstracts.BlockAbstractHorizontalFacing;
import net.cassiokf.industrialrenewal.blockentity.transport.BlockEntityConveyor;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.init.ModItems;
import net.cassiokf.industrialrenewal.util.enums.EnumConveyorTier;
import net.cassiokf.industrialrenewal.util.enums.EnumConveyorType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockConveyor
extends BlockAbstractHorizontalFacing
implements EntityBlock {
    public static final IntegerProperty MODE = IntegerProperty.m_61631_((String)"mode", (int)0, (int)2);
    public static final EnumProperty<EnumConveyorTier> TIER = EnumProperty.m_61587_((String)"tier", EnumConveyorTier.class);
    public static final EnumProperty<EnumConveyorType> TYPE = EnumProperty.m_61587_((String)"type", EnumConveyorType.class);
    public static final BooleanProperty FRONT = BooleanProperty.m_61465_((String)"front");
    public static final BooleanProperty BACK = BooleanProperty.m_61465_((String)"back");
    protected static final VoxelShape BASE_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public BlockConveyor(EnumConveyorType type) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_));
        this.m_49959_((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)type)));
    }

    public BlockConveyor(EnumConveyorTier tier) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60978_(1.0f));
        this.m_49959_((BlockState)this.m_49966_().m_61124_(TIER, (Comparable)((Object)tier)));
    }

    public BlockConveyor(EnumConveyorType type, EnumConveyorTier tier) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)type))).m_61124_(TIER, (Comparable)((Object)tier)));
    }

    public static double getMotionX(Direction facing) {
        return facing == Direction.EAST ? 0.2 : -0.2;
    }

    public static double getMotionZ(Direction facing) {
        return facing == Direction.SOUTH ? 0.2 : -0.2;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{MODE, FRONT, BACK, TIER, TYPE});
    }

    public boolean m_7420_(BlockState p_49928_, BlockGetter p_49929_, BlockPos p_49930_) {
        return true;
    }

    public float m_7749_(BlockState p_60472_, BlockGetter p_60473_, BlockPos p_60474_) {
        return 1.0f;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos neighborPos, boolean p_220069_6_) {
        if (!world.f_46443_) {
            int mode = this.getMode(world, pos, state);
            world.m_7731_(pos, (BlockState)((BlockState)((BlockState)state.m_61124_((Property)MODE, (Comparable)Integer.valueOf(mode))).m_61124_((Property)FRONT, (Comparable)Boolean.valueOf(this.getFront(world, pos, state, mode)))).m_61124_((Property)BACK, (Comparable)Boolean.valueOf(this.getBack(world, pos, state, mode))), 3);
        }
        super.m_6861_(state, world, pos, block, neighborPos, p_220069_6_);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hitResult) {
        ItemStack heldItem = player.m_21120_(handIn);
        if (!heldItem.m_41619_() && handIn.equals((Object)InteractionHand.MAIN_HAND)) {
            if (state.m_61143_(TYPE) == EnumConveyorType.NORMAL && (Integer)state.m_61143_((Property)MODE) == 0) {
                if (heldItem.m_41720_().equals(Blocks.f_50332_.m_5456_())) {
                    state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)EnumConveyorType.HOPPER));
                    worldIn.m_7731_(pos, state, 3);
                    worldIn.m_5594_(null, pos, SoundEvents.f_12065_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (!player.m_7500_()) {
                        heldItem.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (heldItem.m_41720_().equals(Blocks.f_50286_.m_5456_())) {
                    state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)EnumConveyorType.INSERTER));
                    worldIn.m_7731_(pos, state, 3);
                    worldIn.m_5594_(null, pos, SoundEvents.f_12065_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (!player.m_7500_()) {
                        heldItem.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
            } else if (heldItem.m_41720_().equals(ModItems.SCREW_DRIVER.get())) {
                if (state.m_61143_(TYPE) == EnumConveyorType.HOPPER) {
                    Direction facing1 = (Direction)state.m_61143_((Property)FACING);
                    state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)EnumConveyorType.NORMAL));
                    BlockConveyor.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_42155_));
                    worldIn.m_7731_(pos, state, 3);
                    return InteractionResult.SUCCESS;
                }
                if (state.m_61143_(TYPE) == EnumConveyorType.INSERTER) {
                    Direction facing1 = (Direction)state.m_61143_((Property)FACING);
                    state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)EnumConveyorType.NORMAL));
                    BlockConveyor.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_42162_));
                    worldIn.m_7731_(pos, state, 3);
                    return InteractionResult.SUCCESS;
                }
            } else if (Block.m_49814_((Item)heldItem.m_41720_()) instanceof BlockConveyor) {
                Direction face = (Direction)state.m_61143_((Property)FACING);
                int mode = (Integer)state.m_61143_((Property)MODE);
                if (mode == 2 && worldIn.m_8055_(pos.m_121945_(face).m_7495_()).m_247087_()) {
                    if (!worldIn.f_46443_) {
                        worldIn.m_7731_(pos.m_121945_(face).m_7495_(), state, 3);
                        if (!player.m_7500_()) {
                            heldItem.m_41774_(1);
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                if (worldIn.m_8055_(pos.m_121945_(face)).m_247087_()) {
                    if (!worldIn.f_46443_) {
                        worldIn.m_7731_(pos.m_121945_(face), state, 3);
                        if (!player.m_7500_()) {
                            heldItem.m_41774_(1);
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateIn = this.m_49966_();
        int mode = this.getMode(context.m_43725_(), context.m_8083_(), stateIn);
        boolean front = this.getFront(context.m_43725_(), context.m_8083_(), stateIn, mode);
        boolean back = this.getBack(context.m_43725_(), context.m_8083_(), stateIn, mode);
        return (BlockState)((BlockState)((BlockState)((BlockState)stateIn.m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)MODE, (Comparable)Integer.valueOf(mode))).m_61124_((Property)FRONT, (Comparable)Boolean.valueOf(front))).m_61124_((Property)BACK, (Comparable)Boolean.valueOf(back));
    }

    public void m_6786_(LevelAccessor world, BlockPos pos, BlockState state) {
        super.m_6786_(world, pos, state);
        switch ((EnumConveyorType)((Object)state.m_61143_(TYPE))) {
            case HOPPER: {
                BlockConveyor.m_49840_((Level)((Level)world), (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_42155_));
                break;
            }
            case INSERTER: {
                BlockConveyor.m_49840_((Level)((Level)world), (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_42162_));
            }
        }
        BlockPos updatePos = pos.m_7494_();
        BlockPos updatePos2 = pos.m_7495_();
        ((Level)world).m_7260_(updatePos, world.m_8055_(updatePos), world.m_8055_(updatePos), 3);
        ((Level)world).m_7260_(updatePos2, world.m_8055_(updatePos2), world.m_8055_(updatePos2), 3);
        ((Level)world).m_46672_(updatePos, world.m_8055_(updatePos).m_60734_());
        ((Level)world).m_46672_(updatePos2, world.m_8055_(updatePos2).m_60734_());
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        super.m_6402_(world, pos, state, livingEntity, itemStack);
        BlockPos updatePos = pos.m_7494_();
        BlockPos updatePos2 = pos.m_7495_();
        world.m_7260_(updatePos, world.m_8055_(updatePos), world.m_8055_(updatePos), 3);
        world.m_7260_(updatePos2, world.m_8055_(updatePos2), world.m_8055_(updatePos2), 3);
        world.m_46672_(updatePos, world.m_8055_(updatePos).m_60734_());
        world.m_46672_(updatePos2, world.m_8055_(updatePos2).m_60734_());
    }

    private int getMode(Level world, BlockPos pos, BlockState ownState) {
        if (ownState.m_61143_(TYPE) != EnumConveyorType.NORMAL) {
            return 0;
        }
        Direction facing = (Direction)ownState.m_61143_((Property)FACING);
        BlockState frontState = world.m_8055_(pos.m_121945_(facing));
        BlockState upState = world.m_8055_(pos.m_121945_(facing).m_7494_());
        BlockState directUpState = world.m_8055_(pos.m_7494_());
        BlockState downState = world.m_8055_(pos.m_121945_(facing).m_7495_());
        BlockState backUpState = world.m_8055_(pos.m_121945_(facing.m_122424_()).m_7494_());
        BlockState backState = world.m_8055_(pos.m_121945_(facing.m_122424_()));
        if (!(!(upState.m_60734_() instanceof BlockConveyor) || !((Direction)upState.m_61143_((Property)FACING)).equals((Object)facing) || directUpState.m_60734_() instanceof BlockConveyor || frontState.m_60734_() instanceof BlockConveyor && ((Direction)frontState.m_61143_((Property)FACING)).equals((Object)facing))) {
            return 1;
        }
        if (downState.m_60734_() instanceof BlockConveyor && ((Direction)downState.m_61143_((Property)FACING)).equals((Object)facing) && backUpState.m_60734_() instanceof BlockConveyor && ((Direction)backUpState.m_61143_((Property)FACING)).equals((Object)facing) || (!(backState.m_60734_() instanceof BlockConveyor) || !((Direction)backState.m_61143_((Property)FACING)).equals((Object)facing)) && backUpState.m_60734_() instanceof BlockConveyor && ((Direction)backUpState.m_61143_((Property)FACING)).equals((Object)facing)) {
            return 2;
        }
        return 0;
    }

    private boolean getFront(Level world, BlockPos pos, BlockState ownState, int mode) {
        if (((EnumConveyorType)((Object)ownState.m_61143_(TYPE))).equals((Object)EnumConveyorType.INSERTER)) {
            return false;
        }
        Direction facing = (Direction)ownState.m_61143_((Property)FACING);
        BlockState frontState = world.m_8055_(pos.m_121945_(facing));
        BlockState downState = world.m_8055_(pos.m_121945_(facing).m_7495_());
        BlockState aboveState = world.m_8055_(pos.m_121945_(facing).m_7494_());
        return !(frontState.m_60734_() instanceof BlockConveyor) && !(downState.m_60734_() instanceof BlockConveyor) && !(aboveState.m_60734_() instanceof BlockConveyor);
    }

    private boolean getBack(Level world, BlockPos pos, BlockState ownState, int mode) {
        Direction facing = (Direction)ownState.m_61143_((Property)FACING);
        BlockState backState = world.m_8055_(pos.m_121945_(facing.m_122424_()));
        BlockState downState = world.m_8055_(pos.m_121945_(facing.m_122424_()).m_7495_());
        if (mode == 0) {
            return !(backState.m_60734_() instanceof BlockConveyor && ((Direction)backState.m_61143_((Property)FACING)).equals((Object)facing) || downState.m_60734_() instanceof BlockConveyor && ((Direction)downState.m_61143_((Property)FACING)).equals((Object)facing));
        }
        if (mode == 1) {
            return !(downState.m_60734_() instanceof BlockConveyor && ((Direction)downState.m_61143_((Property)FACING)).equals((Object)facing) || backState.m_60734_() instanceof BlockConveyor && ((Direction)backState.m_61143_((Property)FACING)).equals((Object)facing));
        }
        if (mode == 2) {
            return false;
        }
        return false;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter p_60573_, BlockPos p_60574_, CollisionContext p_60575_) {
        return this.getVoxelShape(state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return this.getVoxelShape(state);
    }

    private VoxelShape getVoxelShape(BlockState state) {
        boolean ramp;
        VoxelShape FINAL_SHAPE = NULL_SHAPE;
        Direction face = (Direction)state.m_61143_((Property)FACING);
        int mode = (Integer)state.m_61143_((Property)MODE);
        boolean bl = ramp = mode == 1 || mode == 2;
        if (state.m_61143_(TYPE) == EnumConveyorType.NORMAL) {
            FINAL_SHAPE = Shapes.m_83113_((VoxelShape)FINAL_SHAPE, (VoxelShape)BASE_AABB, (BooleanOp)BooleanOp.f_82695_);
            if (ramp) {
                switch (face) {
                    case NORTH: {
                        FINAL_SHAPE = Shapes.m_83113_((VoxelShape)FINAL_SHAPE, (VoxelShape)NORTH_AABB, (BooleanOp)BooleanOp.f_82695_);
                    }
                    case SOUTH: {
                        FINAL_SHAPE = Shapes.m_83113_((VoxelShape)FINAL_SHAPE, (VoxelShape)SOUTH_AABB, (BooleanOp)BooleanOp.f_82695_);
                    }
                    case WEST: {
                        FINAL_SHAPE = Shapes.m_83113_((VoxelShape)FINAL_SHAPE, (VoxelShape)WEST_AABB, (BooleanOp)BooleanOp.f_82695_);
                    }
                    case EAST: {
                        FINAL_SHAPE = Shapes.m_83113_((VoxelShape)FINAL_SHAPE, (VoxelShape)EAST_AABB, (BooleanOp)BooleanOp.f_82695_);
                    }
                }
            }
        } else {
            FINAL_SHAPE = FULL_SHAPE;
        }
        return FINAL_SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntity.CONVEYOR_TILE.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_153212_, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return ($0, $1, $2, blockEntity) -> ((BlockEntityConveyor)blockEntity).tick();
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean flag) {
        if (!state.m_60713_(oldState.m_60734_())) {
            BlockEntity blockentity = world.m_7702_(pos);
            if (blockentity instanceof BlockEntityConveyor) {
                ((BlockEntityConveyor)blockentity).dropContents();
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, oldState, flag);
        }
    }
}

