/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.block.BlockElectricPump;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntitySyncable;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.util.Utils;
import net.cassiokf.industrialrenewal.util.capability.CustomEnergyStorage;
import net.cassiokf.industrialrenewal.util.capability.CustomFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class BlockEntityElectricPump
extends BlockEntitySyncable
implements ICapabilityProvider {
    private final int energyPerTick = 10;
    private final int energyCapacity = 10000;
    private final int maxRadius = 100;
    private final boolean consumeWater = false;
    private final boolean replaceCobbleConfig = true;
    private final List<BlockPos> fluidSet = new ArrayList<BlockPos>();
    private final CustomFluidTank tank = new CustomFluidTank(10000){

        protected void onContentsChanged() {
            BlockEntityElectricPump.this.m_6596_();
        }

        @Override
        public boolean canDrain() {
            return false;
        }

        @Override
        public boolean canFill() {
            return false;
        }
    };
    private final LazyOptional<CustomFluidTank> tankHandler = LazyOptional.of(() -> this.tank);
    private int index = -1;
    private final int everyXtick = 10;
    private int tick;
    private Direction facing;
    private boolean isRunning = false;
    private boolean starting = false;
    private boolean firstLoad = false;
    private CustomEnergyStorage energyStorage = new CustomEnergyStorage(10000, 10000, 10000){

        @Override
        public void onEnergyChange() {
            BlockEntityElectricPump.this.sync();
        }

        @Override
        public boolean canExtract() {
            return false;
        }
    };
    private final LazyOptional<IEnergyStorage> energyStorageHandler = LazyOptional.of(() -> this.energyStorage);

    public BlockEntityElectricPump(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.ELECTRIC_PUMP_TILE.get(), pos, state);
    }

    public void onLoad() {
        super.onLoad();
    }

    public void setFirstLoad() {
        BlockEntityElectricPump energyInputTile;
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_ && this.getIdex() == 1 && (energyInputTile = (BlockEntityElectricPump)this.f_58857_.m_7702_(this.f_58858_.m_121945_(((Direction)this.m_58900_().m_61143_((Property)BlockElectricPump.FACING)).m_122424_()))) != null) {
            this.energyStorage = energyInputTile.energyStorage;
        }
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_ && this.getIdex() == 1) {
            if (!this.firstLoad) {
                this.firstLoad = true;
                this.setFirstLoad();
            }
            this.isRunning = this.consumeEnergy();
            if (this.tick >= 10) {
                this.tick = 0;
                if (this.isRunning) {
                    this.GetFluidDown();
                    this.passFluidUp();
                    this.sync();
                }
            }
            ++this.tick;
        }
    }

    private int getIdex() {
        if (this.index != -1) {
            return this.index;
        }
        BlockState state = this.m_58900_();
        this.index = state.m_60734_() instanceof BlockElectricPump ? (Integer)state.m_61143_((Property)BlockElectricPump.INDEX) : -1;
        return this.index;
    }

    private boolean consumeEnergy() {
        if (this.energyStorage == null) {
            return false;
        }
        return this.energyStorage.getEnergyStored() >= 10 && this.energyStorage.subtractEnergy(10, false) > 0;
    }

    private void GetFluidDown() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.tank.getFluidAmount() <= this.tank.getCapacity() && this.isRunning) {
            if (this.f_58857_.m_8055_(this.f_58858_.m_7495_()).m_60734_().equals(Blocks.f_49990_)) {
                this.tank.fillInternal(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE);
                return;
            }
            if (this.getFluidSet() != null && !this.getFluidSet().isEmpty()) {
                BlockPos fluidPos = this.getFluidSet().get(0);
                while (!this.instanceOf(fluidPos, true)) {
                    this.getFluidSet().remove(fluidPos);
                    if (this.getFluidSet() == null || this.getFluidSet().isEmpty()) {
                        return;
                    }
                    fluidPos = this.getFluidSet().get(0);
                }
                FluidState state = this.f_58857_.m_6425_(fluidPos);
                if (state.m_76152_().equals(Fluids.f_76193_)) {
                    // empty if block
                }
                boolean consumeFluid = true;
                if (state.m_76170_() && this.tank.fillInternal(new FluidStack(state.m_76152_(), 1000), IFluidHandler.FluidAction.EXECUTE) > 0) {
                    if (state.m_76152_().equals(Fluids.f_76195_)) {
                        this.f_58857_.m_7731_(fluidPos, Blocks.f_50652_.m_49966_(), 3);
                        this.getFluidSet().remove(fluidPos);
                    } else if (consumeFluid) {
                        this.f_58857_.m_46597_(fluidPos, Blocks.f_50016_.m_49966_());
                        this.getFluidSet().remove(fluidPos);
                    }
                }
            }
        }
    }

    private List<BlockPos> getFluidSet() {
        if (this.fluidSet.isEmpty()) {
            this.getAllFluids();
        }
        return this.fluidSet;
    }

    private void getAllFluids() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_6425_(this.f_58858_.m_7495_()) != Fluids.f_76191_.m_76145_()) {
            Stack<BlockPos> traversingFluids = new Stack<BlockPos>();
            ArrayList<BlockPos> flowingPos = new ArrayList<BlockPos>();
            traversingFluids.add(this.f_58858_.m_7495_());
            while (!traversingFluids.isEmpty()) {
                BlockPos fluidPos = (BlockPos)traversingFluids.pop();
                if (this.instanceOf(fluidPos, true)) {
                    this.fluidSet.add(fluidPos);
                } else {
                    flowingPos.add(fluidPos);
                }
                for (Direction d : Direction.values()) {
                    BlockPos newPos = fluidPos.m_121945_(d);
                    if (!this.instanceOf(newPos, false) || this.fluidSet.contains(newPos) || flowingPos.contains(newPos)) continue;
                    traversingFluids.add(newPos);
                }
            }
        }
    }

    private boolean instanceOf(BlockPos pos, boolean checkLevel) {
        if (this.f_58857_ == null) {
            return false;
        }
        if (pos == null) {
            return false;
        }
        FluidState state = this.f_58857_.m_6425_(pos);
        return state != Fluids.f_76191_.m_76145_() && (!checkLevel || state.m_76170_()) && Utils.getDistanceSq(this.f_58858_, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()) <= 10000.0;
    }

    private void passFluidUp() {
        IFluidHandler upTank = this.GetTankUp();
        if (upTank != null) {
            upTank.fill(this.tank.drainInternal(this.tank.getCapacity() / 10, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void invalidateCaps() {
        this.energyStorageHandler.invalidate();
        this.tankHandler.invalidate();
        super.invalidateCaps();
    }

    public void m_7651_() {
        super.m_7651_();
    }

    private BlockEntityElectricPump getMotor() {
        if (this.f_58857_ == null) {
            return null;
        }
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(((Direction)this.m_58900_().m_61143_((Property)BlockElectricPump.FACING)).m_122424_()));
        if (te != null && te instanceof BlockEntityElectricPump && ((BlockEntityElectricPump)te).index == 0) {
            return (BlockEntityElectricPump)te;
        }
        return null;
    }

    private IFluidHandler GetTankUp() {
        if (this.f_58857_ == null) {
            return null;
        }
        BlockEntity upTE = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
        if (upTE != null) {
            return (IFluidHandler)upTE.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.DOWN).orElse(null);
        }
        return null;
    }

    private Direction getBlockFacing() {
        if (this.facing != null) {
            return this.facing;
        }
        this.facing = (Direction)this.m_58900_().m_61143_((Property)BlockElectricPump.FACING);
        return this.facing;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        int index = this.getIdex();
        if (facing == null) {
            return super.getCapability(capability, facing);
        }
        if (index == 1 && capability == ForgeCapabilities.FLUID_HANDLER && facing == Direction.UP) {
            return LazyOptional.of(() -> this.tank).cast();
        }
        Direction face = this.getBlockFacing();
        if (index == 0 && capability == ForgeCapabilities.ENERGY && facing == face.m_122424_()) {
            return this.energyStorageHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        CompoundTag tag = new CompoundTag();
        this.tank.writeToNBT(tag);
        compoundTag.m_128365_("fluid", (Tag)tag);
        compoundTag.m_128379_("isRunning", this.isRunning);
        compoundTag.m_128379_("starting", this.starting);
        compoundTag.m_128405_("energy", this.energyStorage.getEnergyStored());
        super.m_183515_(compoundTag);
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        CompoundTag tag = compoundTag.m_128469_("fluid");
        this.tank.readFromNBT(tag);
        this.isRunning = compoundTag.m_128471_("isRunning");
        this.starting = compoundTag.m_128471_("starting");
        this.energyStorage.setEnergy(compoundTag.m_128451_("energy"));
        super.m_142466_(compoundTag);
    }
}

