/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity;

import net.cassiokf.industrialrenewal.block.BlockFluidGauge;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntitySyncable;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockEntityFluidGauge
extends BlockEntitySyncable {
    private Direction indicatorHorizontalFacing;
    private Direction baseFacing;
    private IFluidHandler fluidStorage;

    public BlockEntityFluidGauge(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.FLUID_GAUGE.get(), pos, state);
    }

    public String getText() {
        if (this.getTankStorage() != null && this.getTankStorage().getTanks() > 0) {
            FluidStack stack = this.getTankStorage().getFluidInTank(0);
            return stack != null && !stack.isEmpty() ? stack.getDisplayName().getString() : "Empty";
        }
        return "No Tank";
    }

    public Direction getGaugeFacing() {
        if (this.indicatorHorizontalFacing != null) {
            return this.indicatorHorizontalFacing;
        }
        return this.forceIndicatorCheck();
    }

    public Direction forceIndicatorCheck() {
        this.indicatorHorizontalFacing = (Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockFluidGauge.GAUGE);
        return this.indicatorHorizontalFacing;
    }

    public Direction getBaseFacing() {
        if (this.baseFacing != null) {
            return this.baseFacing;
        }
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (state.m_60734_() instanceof BlockFluidGauge) {
            this.baseFacing = (Direction)state.m_61143_((Property)BlockFluidGauge.FACING);
        }
        return this.baseFacing;
    }

    public void setBaseFacing(Direction baseFacing) {
        this.baseFacing = baseFacing;
    }

    public float getTankFill() {
        if (this.getTankStorage() != null && this.getTankStorage().getTanks() > 0) {
            float currentAmount = (float)this.getTankStorage().getFluidInTank(0).getAmount() / 1000.0f;
            float totalCapacity = (float)this.getTankStorage().getTankCapacity(0) / 1000.0f;
            return (currentAmount /= totalCapacity) * 180.0f;
        }
        return 0.0f;
    }

    private IFluidHandler getTankStorage() {
        if (this.fluidStorage != null) {
            return this.fluidStorage;
        }
        return this.forceCheck();
    }

    public IFluidHandler forceCheck() {
        IFluidHandler handler;
        if (this.f_58857_ == null) {
            return null;
        }
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(this.getBaseFacing()));
        if (te != null && (handler = (IFluidHandler)te.getCapability(ForgeCapabilities.FLUID_HANDLER, this.baseFacing.m_122424_()).orElse(null)) != null) {
            this.fluidStorage = handler;
            return this.fluidStorage;
        }
        this.fluidStorage = null;
        this.sync();
        return null;
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        compoundTag.m_128379_("fluid", this.fluidStorage != null);
        super.m_183515_(compoundTag);
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        if (!compoundTag.m_128471_("fluid")) {
            this.fluidStorage = null;
        }
        super.m_142466_(compoundTag);
    }
}

