/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntityTowerBase;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.util.Utils;
import net.cassiokf.industrialrenewal.util.capability.CustomFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class BlockEntityFluidTank
extends BlockEntityTowerBase<BlockEntityFluidTank> {
    public static final int CAPACITY = 1000000;
    private static final int MAX_TRANSFER = 10000;
    private final CustomFluidTank tank = new CustomFluidTank(1000000).setBlockEntity(this);
    private final LazyOptional<FluidTank> tankHandler = LazyOptional.of(() -> this.tank);
    private boolean firstLoad = false;
    private int tick = 0;
    private int maxCapacity = 0;
    private int sumCurrent = 0;

    public BlockEntityFluidTank(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.FLUID_TANK_TILE.get(), pos, state);
    }

    public void setFirstLoad() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_ && this.isMaster()) {
            if (this.isBase()) {
                if (this.tower == null || this.tower.isEmpty()) {
                    this.loadTower();
                }
            } else {
                this.tower = ((BlockEntityFluidTank)((Object)this.getBase())).tower;
            }
        }
    }

    @Override
    public boolean instanceOf(BlockEntity tileEntity) {
        return tileEntity instanceof BlockEntityFluidTank;
    }

    public void invalidateCaps() {
        this.tankHandler.invalidate();
        super.invalidateCaps();
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_ && this.isMaster()) {
            if (!this.firstLoad) {
                this.firstLoad = true;
                this.setFirstLoad();
            }
            if (this.isBase()) {
                IFluidHandler handler;
                BlockEntity te;
                if (this.tank.getFluidAmount() > 0 && (te = this.f_58857_.m_7702_(this.f_58858_.m_7495_().m_5484_(this.getMasterFacing().m_122424_(), 2))) != null && (handler = (IFluidHandler)te.getCapability(ForgeCapabilities.FLUID_HANDLER, this.getMasterFacing()).orElse(null)) != null) {
                    this.tank.drainInternal(handler.fill(this.tank.drainInternal(10000, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                }
            } else if (this.isTop()) {
                this.passFluidDown();
            }
            if (this.tick >= 5) {
                this.tick = 0;
                this.maxCapacity = this.getSumMaxFluid();
                this.sumCurrent = this.getSumCurrentFluid();
                this.sync();
            }
            ++this.tick;
        }
    }

    public void passFluidDown() {
        if (((BlockEntityFluidTank)((Object)this.getBase())).tower != null && !((BlockEntityFluidTank)((Object)this.getBase())).tower.isEmpty()) {
            for (BlockEntityTowerBase TE : ((BlockEntityFluidTank)((Object)this.getBase())).tower) {
                BlockEntityFluidTank bankTE;
                if (!(TE instanceof BlockEntityFluidTank) || (bankTE = (BlockEntityFluidTank)TE).isFull() || bankTE == this) continue;
                this.tank.drainInternal(bankTE.tank.fill(this.tank.drainInternal(10000, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                break;
            }
        }
    }

    public boolean isFull() {
        return this.tank.getFluidAmount() >= this.tank.getCapacity();
    }

    public int getSumMaxFluid() {
        if (this.tower == null || this.tower.isEmpty()) {
            return 0;
        }
        int max = this.tower.stream().map(te -> te.tank.getCapacity()).reduce(0, Integer::sum);
        return max;
    }

    public int getSumCurrentFluid() {
        if (this.tower == null || this.tower.isEmpty()) {
            return 0;
        }
        int current = this.tower.stream().map(te -> te.tank.getFluidAmount()).reduce(0, Integer::sum);
        return current;
    }

    public String getFluidName() {
        String name = this.tank.getFluidAmount() > 0 ? this.tank.getFluid().getDisplayName().getString() : "Empty";
        return name + ": " + Utils.formatEnergyString(this.sumCurrent / 1000).replace("FE", "B") + " / " + Utils.formatEnergyString(this.maxCapacity / 1000).replace("FE", "B");
    }

    public float getFluidAngle() {
        return Utils.normalizeClamped(this.sumCurrent, 0.0f, this.maxCapacity) * 180.0f;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        Direction downFace = this.getMasterFacing().m_122424_();
        BlockEntityFluidTank master = (BlockEntityFluidTank)((Object)this.getMaster());
        if (side == null) {
            return super.getCapability(cap, side);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (side == downFace && this.f_58858_.equals((Object)master.f_58858_.m_7495_().m_121945_(downFace))) {
                return ((BlockEntityFluidTank)((Object)this.getMaster())).tankHandler.cast();
            }
            if (side == Direction.UP && this.f_58858_.equals((Object)master.f_58858_.m_7494_())) {
                return ((BlockEntityFluidTank)((Object)this.getMaster())).tankHandler.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        compoundTag.m_128405_("max", this.maxCapacity);
        compoundTag.m_128405_("current", this.sumCurrent);
        this.tank.writeToNBT(compoundTag);
        super.m_183515_(compoundTag);
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        this.maxCapacity = compoundTag.m_128451_("max");
        this.sumCurrent = compoundTag.m_128451_("current");
        this.tank.readFromNBT(compoundTag);
        super.m_142466_(compoundTag);
    }
}

