/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntitySyncable;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.init.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class BlockEntityHVIsolator
extends BlockEntitySyncable {
    public Set<BlockPos> neighbors = new HashSet<BlockPos>();
    public Set<BlockPos> allNodes = new HashSet<BlockPos>();

    public BlockEntityHVIsolator(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.ISOLATOR_TILE.get(), pos, state);
        this.allNodes.add(this.f_58858_);
    }

    public void remove() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)new ItemStack((ItemLike)ModItems.WIRE_COIL.get(), this.neighbors.size()));
            this.unlinkAll();
        }
    }

    public boolean link(BlockEntityHVIsolator neighbor) {
        if (this.neighbors.contains(neighbor.f_58858_) && neighbor.neighbors.contains(this.f_58858_)) {
            return false;
        }
        this.neighbors.add(neighbor.f_58858_);
        neighbor.neighbors.add(this.f_58858_);
        this.search();
        this.propagate();
        this.update();
        neighbor.update();
        return true;
    }

    public void unlinkAll() {
        if (this.f_58857_ == null) {
            return;
        }
        for (BlockPos neighbor : this.neighbors) {
            BlockEntity te = this.f_58857_.m_7702_(neighbor);
            if (!(te instanceof BlockEntityHVIsolator)) continue;
            BlockEntityHVIsolator nodeTE = (BlockEntityHVIsolator)te;
            nodeTE.neighbors.remove(this.f_58858_);
            nodeTE.search();
            nodeTE.propagate();
            nodeTE.update();
        }
    }

    public void search() {
        if (this.f_58857_ == null) {
            return;
        }
        this.allNodes.clear();
        this.allNodes.add(this.f_58858_);
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(this.f_58858_);
        while (!queue.isEmpty()) {
            BlockPos node = (BlockPos)queue.poll();
            BlockEntity te = this.f_58857_.m_7702_(node);
            if (te == null) continue;
            BlockEntityHVIsolator nodeTE = (BlockEntityHVIsolator)te;
            for (BlockPos neighborNodes : nodeTE.neighbors) {
                if (this.allNodes.contains(neighborNodes)) continue;
                this.allNodes.add(neighborNodes);
                queue.add(neighborNodes);
            }
        }
        this.update();
    }

    public void propagate() {
        if (this.f_58857_ == null) {
            return;
        }
        HashSet<BlockPos> clone = new HashSet<BlockPos>(this.allNodes);
        for (BlockPos node : this.allNodes) {
            BlockEntity te = this.f_58857_.m_7702_(node);
            if (te == null) continue;
            BlockEntityHVIsolator nodeTE = (BlockEntityHVIsolator)te;
            nodeTE.allNodes = clone;
            nodeTE.update();
        }
    }

    public void update() {
        this.sync();
    }

    public long[] saveNeighbors() {
        return this.neighbors.stream().map(BlockPos::m_121878_).mapToLong(i -> i).toArray();
    }

    public long[] saveAllNodes() {
        return this.allNodes.stream().map(BlockPos::m_121878_).mapToLong(i -> i).toArray();
    }

    public void loadNeighbors(long[] savedNeighbors) {
        if (this.neighbors != null) {
            this.neighbors.clear();
        } else {
            this.neighbors = new HashSet<BlockPos>();
        }
        for (long blockPos : savedNeighbors) {
            this.neighbors.add(BlockPos.m_122022_((long)blockPos));
        }
    }

    public void loadAllNodes(long[] savedAllNodes) {
        if (this.allNodes != null) {
            this.allNodes.clear();
        } else {
            this.allNodes = new HashSet<BlockPos>();
        }
        for (long blockPos : savedAllNodes) {
            this.allNodes.add(BlockPos.m_122022_((long)blockPos));
        }
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        compoundTag.m_128388_("neighbors", this.saveNeighbors());
        compoundTag.m_128388_("all_nodes", this.saveAllNodes());
        super.m_183515_(compoundTag);
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        this.loadNeighbors(compoundTag.m_128467_("neighbors"));
        this.loadAllNodes(compoundTag.m_128467_("all_nodes"));
        super.m_142466_(compoundTag);
    }

    public String toString() {
        return "TileEntityWireIsolator " + String.valueOf(this.f_58858_);
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

