/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity;

import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.util.capability.CustomEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityInfinityGenerator
extends BlockEntity {
    private final CustomEnergyStorage energyContainer = new CustomEnergyStorage(0, 0, 0){

        @Override
        public boolean canReceive() {
            return false;
        }

        @Override
        public boolean canExtract() {
            return false;
        }
    };
    private final LazyOptional<IEnergyStorage> optional = LazyOptional.of(() -> this.energyContainer);

    public BlockEntityInfinityGenerator(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntity.INFINITY_GENERATOR.get(), pPos, pBlockState);
    }

    public void tick() {
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_) {
            for (Direction facing : Direction.Plane.HORIZONTAL) {
                this.updatePanel(facing, Integer.MAX_VALUE);
            }
        }
    }

    public void updatePanel(Direction facing, int energy) {
        BlockEntity be = this.f_58857_.m_7702_(this.f_58858_.m_121945_(facing));
        if (be != null && !be.m_58901_()) {
            be.getCapability(ForgeCapabilities.ENERGY, facing.m_122424_()).ifPresent(iEnergyStorage -> iEnergyStorage.receiveEnergy(energy, false));
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY && side != Direction.UP && side != Direction.DOWN) {
            return this.optional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.optional.invalidate();
    }
}

