/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntity3x2x2MachineBase;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.util.Utils;
import net.cassiokf.industrialrenewal.util.capability.CustomEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class BlockEntityLathe
extends BlockEntity3x2x2MachineBase<BlockEntityLathe>
implements MenuProvider {
    private static final int energyPTick = 10;
    public final int MAX_ENERGY = 10000;
    public boolean inProcess = false;
    public float renderCutterProcess;
    public LazyOptional<CustomEnergyStorage> energyHandler;
    public LazyOptional<ItemStackHandler> inputItemHandler;
    public LazyOptional<ItemStackHandler> outputItemHandler;
    public LazyOptional<ItemStackHandler> holdHandler;
    public int currentEnergy;
    private final CustomEnergyStorage energyContainer = new CustomEnergyStorage(10000, 256, 256){

        @Override
        public void onEnergyChange() {
            BlockEntityLathe.this.currentEnergy = this.getEnergyStored();
            BlockEntityLathe.this.sync();
        }

        @Override
        public boolean canExtract() {
            return false;
        }
    };
    private final ItemStackHandler input = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            BlockEntityLathe.this.sync();
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    };
    private final ItemStackHandler output = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            BlockEntityLathe.this.sync();
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    };
    private final ItemStackHandler hold = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            BlockEntityLathe.this.sync();
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    };
    private boolean oldInProcess;
    private int tick;
    private int processTime;
    private float oldProcessTime;
    private boolean stopping = false;

    public BlockEntityLathe(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.LATHE_TILE.get(), pos, state);
        this.energyHandler = LazyOptional.of(() -> this.energyContainer);
        this.inputItemHandler = LazyOptional.of(() -> this.input);
        this.outputItemHandler = LazyOptional.of(() -> this.output);
        this.holdHandler = LazyOptional.of(() -> this.hold);
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_ && this.isMaster()) {
            ItemStack inputStack = this.input.getStackInSlot(0);
            this.oldProcessTime = this.renderCutterProcess;
            if (!this.inProcess && !inputStack.m_41619_() && this.valid(this.output.getStackInSlot(0))) {
                this.getProcessFromInputItem();
            } else if (this.inProcess) {
                this.getProcessFromInputItem();
                this.process();
            }
            if (inputStack.m_41619_() || !this.valid(this.output.getStackInSlot(0))) {
                this.interrupt();
            }
            if (!this.inProcess && !this.oldInProcess) {
                this.stopping = true;
            }
            this.oldInProcess = this.inProcess;
            this.renderCutterProcess = this.processTime > 0 ? Utils.normalizeClamped(this.tick, 0.0f, this.processTime) * 0.8f : 0.0f;
            this.tryOutPutItem();
            this.sync();
        }
    }

    public void interrupt() {
        this.inProcess = false;
        this.processTime = 0;
        this.tick = 0;
        this.stopping = true;
        this.hold.setStackInSlot(0, ItemStack.f_41583_);
    }

    private boolean valid(ItemStack outputSlot) {
        return false;
    }

    private void process() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.energyContainer.getEnergyStored() < 10) {
            return;
        }
        this.energyContainer.extractEnergy(10, false);
        ++this.tick;
        if (this.tick >= this.processTime) {
            this.tick = 0;
            this.processTime = 0;
            this.inProcess = false;
            if (!this.f_58857_.f_46443_) {
                this.input.extractItem(0, 1, false);
                this.output.insertItem(0, this.hold.extractItem(0, 64, false), false);
            }
        }
    }

    private void getProcessFromInputItem() {
    }

    private void tryOutPutItem() {
        IItemHandler outputCap;
        Direction facing;
        BlockEntity te;
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_ && !this.output.getStackInSlot(0).m_41619_() && (te = this.f_58857_.m_7702_(this.f_58858_.m_5484_(facing = this.getMasterFacing().m_122427_(), 2))) != null && (outputCap = (IItemHandler)te.getCapability(ForgeCapabilities.ITEM_HANDLER, facing.m_122424_()).orElse(null)) != null) {
            Utils.moveItemsBetweenInventories((IItemHandler)this.output, outputCap);
        }
    }

    @Override
    public boolean instanceOf(BlockEntity tileEntity) {
        return tileEntity instanceof BlockEntityLathe;
    }

    @Override
    public void onMasterBreak() {
        Utils.dropInventoryItems(this.f_58857_, this.f_58858_.m_121945_(this.getMasterFacing().m_122428_()), this.input);
        Utils.dropInventoryItems(this.f_58857_, this.f_58858_.m_121945_(this.getMasterFacing().m_122427_()), this.output);
        super.onMasterBreak();
    }

    public IItemHandler getInputInv() {
        return this.input;
    }

    public IItemHandler getOutputInv() {
        return this.output;
    }

    public ItemStack getResultItem() {
        return this.hold.getStackInSlot(0);
    }

    public float getNormalizedProcess() {
        return this.renderCutterProcess;
    }

    public float getOldProcess() {
        return this.oldProcessTime;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        BlockEntityLathe masterTE = (BlockEntityLathe)this.getMaster();
        if (masterTE == null || facing == null) {
            return super.getCapability(capability, facing);
        }
        if (capability.equals((Object)ForgeCapabilities.ENERGY) && facing.equals((Object)this.getMasterFacing()) && this.f_58858_.equals((Object)masterTE.m_58899_().m_121945_(this.getMasterFacing()).m_121945_(this.getMasterFacing().m_122428_()))) {
            return ((BlockEntityLathe)this.getMaster()).energyHandler.cast();
        }
        if (capability.equals((Object)ForgeCapabilities.ITEM_HANDLER)) {
            if (facing.equals((Object)this.getMasterFacing().m_122428_()) && this.f_58858_.equals((Object)masterTE.m_58899_().m_121945_(this.getMasterFacing().m_122428_()))) {
                return ((BlockEntityLathe)this.getMaster()).inputItemHandler.cast();
            }
            if (facing.equals((Object)this.getMasterFacing().m_122427_()) && this.f_58858_.equals((Object)masterTE.m_58899_().m_121945_(this.getMasterFacing().m_122427_()))) {
                return ((BlockEntityLathe)this.getMaster()).outputItemHandler.cast();
            }
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        compoundTag.m_128405_("current", this.currentEnergy);
        compoundTag.m_128350_("progress", this.renderCutterProcess);
        compoundTag.m_128405_("tick", this.tick);
        compoundTag.m_128405_("processTime", this.processTime);
        compoundTag.m_128379_("processing", this.inProcess);
        this.inputItemHandler.ifPresent(in -> {
            CompoundTag tag = in.serializeNBT();
            compoundTag.m_128365_("input", (Tag)tag);
        });
        this.outputItemHandler.ifPresent(out -> {
            CompoundTag tag = out.serializeNBT();
            compoundTag.m_128365_("output", (Tag)tag);
        });
        this.holdHandler.ifPresent(handler -> {
            CompoundTag tag = handler.serializeNBT();
            compoundTag.m_128365_("hold", (Tag)tag);
        });
        compoundTag.m_128405_("energy", this.energyContainer.getEnergyStored());
        super.m_183515_(compoundTag);
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        this.currentEnergy = compoundTag.m_128451_("current");
        this.renderCutterProcess = compoundTag.m_128457_("progress");
        this.tick = compoundTag.m_128451_("tick");
        this.processTime = compoundTag.m_128451_("processTime");
        this.inProcess = compoundTag.m_128471_("processing");
        this.inputItemHandler.ifPresent(input -> input.deserializeNBT(compoundTag.m_128469_("input")));
        this.outputItemHandler.ifPresent(output -> output.deserializeNBT(compoundTag.m_128469_("output")));
        this.holdHandler.ifPresent(handler -> handler.deserializeNBT(compoundTag.m_128469_("hold")));
        this.energyContainer.setEnergy(compoundTag.m_128451_("energy"));
        super.m_142466_(compoundTag);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237113_((String)"Lathe");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return null;
    }
}

