/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity;

import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntitySyncable;
import net.cassiokf.industrialrenewal.blockentity.abstracts.FluidGenerator;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.util.Utils;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class BlockEntityPortableGenerator
extends BlockEntitySyncable {
    private final FluidGenerator generator = new FluidGenerator(this);
    private final float volume = 0.5f;
    private final boolean soundStarted = false;
    private final BlockState state;

    public BlockEntityPortableGenerator(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.PORTABLE_GENERATOR_TILE.get(), pos, state);
        this.state = state;
    }

    public FluidTank getTank() {
        return this.generator.tank;
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.m_5776_()) {
            this.generator.onTick();
            this.passEnergy();
        } else {
            this.handleSound();
        }
    }

    private void passEnergy() {
        BlockEntity te;
        if (this.f_58857_ == null) {
            return;
        }
        if (this.generator.energyStorage.getEnergyStored() >= 0 && (te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(this.getBlockFacing()))) != null) {
            te.getCapability(ForgeCapabilities.ENERGY, this.getBlockFacing()).ifPresent(cap -> {
                if (cap.canReceive()) {
                    int amount = cap.receiveEnergy(this.generator.energyStorage.extractEnergy(128, true), true);
                    this.generator.energyStorage.extractEnergy(cap.receiveEnergy(amount, false), false);
                }
            });
        }
    }

    private void handleSound() {
    }

    public boolean isGenerating() {
        return this.generator.isGenerating();
    }

    public String getTankContent() {
        return this.generator.getTankContent();
    }

    public int getTankAmount() {
        return this.generator.getTankAmount();
    }

    public int getGenerateAmount() {
        return this.generator.getGenerateAmount();
    }

    public void m_7651_() {
        super.m_7651_();
    }

    public void invalidateCaps() {
        this.generator.invalidate();
    }

    public void changeGenerator() {
        this.generator.changeCanGenerate();
    }

    public boolean isWorking() {
        return this.generator.isGenerating();
    }

    public Direction getBlockFacing() {
        return (Direction)this.state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
    }

    public float getTankFill() {
        return Utils.normalizeClamped(this.getTank().getFluidAmount(), 0.0f, this.getTank().getCapacity()) * 180.0f;
    }

    public String getTankText() {
        return this.getTank().getFluidAmount() > 0 ? I18n.m_118938_((String)this.getTank().getFluid().getTranslationKey(), (Object[])new Object[0]) : "Empty";
    }

    public float getEnergyFill() {
        return Utils.normalizeClamped(this.generator.isGenerating() ? (float)FluidGenerator.energyPerTick : 0.0f, 0.0f, 128.0f) * 90.0f;
    }

    public String getEnergyText() {
        return Utils.formatEnergyString(this.generator.isGenerating() ? FluidGenerator.energyPerTick : 0) + "/t";
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (facing == null) {
            return super.getCapability(capability, facing);
        }
        if (capability == ForgeCapabilities.ENERGY && facing == this.getBlockFacing()) {
            return this.generator.energyHandler.cast();
        }
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return this.generator.tankHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void setCanGenerate(boolean value) {
        this.generator.setCanGenerate(value);
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        this.generator.saveGenerator(compoundTag);
        super.m_183515_(compoundTag);
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        this.generator.loadGenerator(compoundTag);
        super.m_142466_(compoundTag);
    }
}

