/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.block.BlockSolarPanel;
import net.cassiokf.industrialrenewal.block.BlockSolarPanelFrame;
import net.cassiokf.industrialrenewal.blockentity.BlockEntitySolarPanel;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntityMultiBlocksTube;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.util.Utils;
import net.cassiokf.industrialrenewal.util.capability.CustomEnergyStorage;
import net.cassiokf.industrialrenewal.util.capability.CustomItemStackHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class BlockEntitySolarPanelFrame
extends BlockEntityMultiBlocksTube<BlockEntitySolarPanelFrame> {
    public final LazyOptional<CustomItemStackHandler> panelInv = LazyOptional.of(this::createHandler);
    private final Set<BlockEntitySolarPanelFrame> panelReady = new HashSet<BlockEntitySolarPanelFrame>();
    private final int MAX_CAPACITY = 10000;
    private final int MAX_TRANSFER_RATE = 10000;
    private final float MULTIPLIER = 2.0f;
    private final boolean DECORATIVE = false;
    public CustomEnergyStorage energyStorage = new CustomEnergyStorage(10000, 0, 10000){

        @Override
        public void onEnergyChange() {
            BlockEntitySolarPanelFrame.this.sync();
        }
    };
    private final LazyOptional<IEnergyStorage> energyStorageHandler = LazyOptional.of(() -> this.energyStorage);
    private int tick;
    private Direction blockFacing;

    public BlockEntitySolarPanelFrame(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.SOLAR_PANEL_FRAME.get(), pos, state);
    }

    private CustomItemStackHandler createHandler() {
        return new CustomItemStackHandler(1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (stack.m_41619_()) {
                    return false;
                }
                return Block.m_49814_((Item)stack.m_41720_()) instanceof BlockSolarPanel;
            }

            @Override
            protected void onContentsChanged(int slot) {
                BlockEntitySolarPanelFrame.this.sync();
            }
        };
    }

    @Override
    public boolean instanceOf(BlockEntity te) {
        return te instanceof BlockEntitySolarPanelFrame;
    }

    @Override
    public void doTick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            if (this.isMaster()) {
                IEnergyStorage thisEnergy = (IEnergyStorage)this.energyStorageHandler.orElse(null);
                int size = this.panelReady.size();
                this.energyStorageHandler.ifPresent(e -> ((CustomEnergyStorage)((Object)e)).setMaxCapacity(Math.max(10000 * size, thisEnergy.getEnergyStored())));
                if (size > 0) {
                    this.getEnergyFromSun();
                }
                for (BlockEntity tileEntity : this.getReceivers().keySet()) {
                    Direction facing;
                    IEnergyStorage consumer;
                    if (tileEntity == null || tileEntity.m_58901_() || (consumer = (IEnergyStorage)tileEntity.getCapability(ForgeCapabilities.ENERGY, (facing = this.getReceivers().get(tileEntity)).m_122424_()).orElse(null)) == null) continue;
                    thisEnergy.extractEnergy(consumer.receiveEnergy(thisEnergy.extractEnergy(10000, true), false), false);
                }
            }
            if (this.tick >= 20) {
                this.tick = 0;
                this.checkIfIsReady();
            }
            ++this.tick;
        }
    }

    public void checkIfIsReady() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.hasPanel() && this.f_58857_.m_45527_(this.f_58858_.m_121945_(Direction.UP)) && this.f_58857_.m_45517_(LightLayer.SKY, this.f_58858_) > 0) {
            ((BlockEntitySolarPanelFrame)((Object)this.getMaster())).getPanelReadySet().add(this);
        } else {
            ((BlockEntitySolarPanelFrame)((Object)this.getMaster())).getPanelReadySet().remove((Object)this);
        }
    }

    public void getEnergyFromSun() {
        IEnergyStorage thisEnergy = (IEnergyStorage)((BlockEntitySolarPanelFrame)((Object)this.getMaster())).energyStorageHandler.orElse(null);
        if (thisEnergy.getEnergyStored() < thisEnergy.getMaxEnergyStored()) {
            int result;
            int energy = result = Math.round((float)(BlockEntitySolarPanel.getGeneration(this.f_58857_, this.f_58858_) * this.panelReady.size()) * this.getMultiplier());
            this.energyStorageHandler.ifPresent(e -> ((CustomEnergyStorage)((Object)e)).addEnergy(energy));
        }
    }

    @Override
    public void checkForOutPuts(BlockPos pos) {
        if (this.f_58857_ == null) {
            return;
        }
        this.getPanelReadySet().clear();
        if (this.f_58857_.f_46443_) {
            return;
        }
        for (Direction face : Direction.values()) {
            boolean hasMachine;
            boolean canConnect;
            Direction facing = this.getBlockFacing();
            boolean bl = canConnect = face == facing || face == facing.m_122427_() || face == facing.m_122428_();
            if (!canConnect) continue;
            BlockPos currentPos = pos.m_121945_(face);
            BlockState state = this.f_58857_.m_8055_(currentPos);
            BlockEntity te = this.f_58857_.m_7702_(currentPos);
            boolean bl2 = hasMachine = !(state.m_60734_() instanceof BlockSolarPanelFrame) && te != null && te.getCapability(ForgeCapabilities.ENERGY, face.m_122424_()).isPresent();
            if (hasMachine) {
                if (this.isMasterInvalid()) continue;
                ((BlockEntitySolarPanelFrame)((Object)this.getMaster())).addReceiver(te, face);
                continue;
            }
            if (this.isMasterInvalid()) continue;
            ((BlockEntitySolarPanelFrame)((Object)this.getMaster())).removeReceiver(te);
        }
    }

    public Direction getBlockFacing() {
        if (this.blockFacing == null) {
            BlockState state = this.m_58900_();
            this.blockFacing = state.m_60734_() instanceof BlockSolarPanelFrame ? (Direction)state.m_61143_((Property)BlockSolarPanelFrame.FACING) : Direction.NORTH;
        }
        return this.blockFacing;
    }

    @Override
    public void removeReceiver(BlockEntity machine) {
        super.removeReceiver(machine);
    }

    private float getMultiplier() {
        return 2.0f;
    }

    public Set<BlockEntitySolarPanelFrame> getPanelReadySet() {
        return this.panelReady;
    }

    public boolean hasPanel() {
        return !((CustomItemStackHandler)((Object)this.panelInv.orElse(null))).getStackInSlot(0).m_41619_();
    }

    public ItemStack getPanel() {
        return ((CustomItemStackHandler)((Object)this.panelInv.orElse(null))).getStackInSlot(0);
    }

    public IItemHandler getPanelHandler() {
        return (IItemHandler)this.panelInv.orElse(null);
    }

    @Override
    public void breakBlock() {
        if (!((CustomItemStackHandler)((Object)this.panelInv.orElse(null))).getStackInSlot(0).m_41619_()) {
            Utils.dropInventoryItems(this.f_58857_, this.f_58858_, (ItemStackHandler)this.panelInv.orElse(null));
        }
        super.breakBlock();
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        compound.m_128405_("energy", this.energyStorage.getEnergyStored());
        this.panelInv.ifPresent(h -> {
            CompoundTag tag = h.serializeNBT();
            compound.m_128365_("inv", (Tag)tag);
        });
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.energyStorage.setEnergy(compound.m_128451_("energy"));
        this.panelInv.ifPresent(h -> h.deserializeNBT(compound.m_128469_("inv")));
        super.m_142466_(compound);
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        boolean canConnect;
        Direction face = this.getBlockFacing();
        if (facing == null) {
            return super.getCapability(capability, facing);
        }
        boolean bl = canConnect = facing == face || facing == face.m_122427_() || facing == face.m_122428_();
        if (capability == ForgeCapabilities.ENERGY && canConnect) {
            return ((BlockEntitySolarPanelFrame)((Object)this.getMaster())).energyStorageHandler.cast();
        }
        return super.getCapability(capability, facing);
    }
}

