/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.block.BlockTransformer;
import net.cassiokf.industrialrenewal.blockentity.BlockEntityHVIsolator;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntity3x2x3MachineBase;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.init.ModBlocks;
import net.cassiokf.industrialrenewal.obj.CapPercentage;
import net.cassiokf.industrialrenewal.util.Utils;
import net.cassiokf.industrialrenewal.util.capability.CustomEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class BlockEntityTransformer
extends BlockEntity3x2x3MachineBase<BlockEntityTransformer> {
    private static int TRANSFER_SPEED = 10240;
    private final CustomEnergyStorage energyDummy = new CustomEnergyStorage(0);
    private final LazyOptional<CustomEnergyStorage> dummyHandler = LazyOptional.of(() -> this.energyDummy);
    private int tick = 0;
    private int averageEnergy = 0;
    private int energyOverTime = 0;
    private final CustomEnergyStorage energyStorage = new CustomEnergyStorage(TRANSFER_SPEED, TRANSFER_SPEED, TRANSFER_SPEED){

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            return BlockEntityTransformer.this.distributeEnergy(maxReceive, simulate);
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }
    };
    private final LazyOptional<CustomEnergyStorage> energyStorageHandler = LazyOptional.of(() -> this.energyStorage);

    public BlockEntityTransformer(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.TRANSFORMER_TILE.get(), pos, state);
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (this.tick % 10 == 0) {
                this.tick = 0;
                int old = this.averageEnergy;
                this.averageEnergy = this.energyOverTime / 10;
                this.energyOverTime = 0;
                if (this.averageEnergy != old) {
                    this.sync();
                }
            }
            ++this.tick;
        }
    }

    private boolean extract() {
        return this.m_58900_().m_60713_((Block)ModBlocks.TRANSFORMER.get()) && (Integer)this.m_58900_().m_61143_((Property)BlockTransformer.OUTPUT) == 2;
    }

    private Direction getFacing() {
        return this.m_58900_().m_60713_((Block)ModBlocks.TRANSFORMER.get()) ? (Direction)this.m_58900_().m_61143_((Property)BlockTransformer.FACING) : Direction.NORTH;
    }

    private int distributeEnergy(int energy, boolean simulate) {
        BlockEntityHVIsolator isolator = this.getIsolator();
        int out = 0;
        if (isolator != null) {
            Set<BlockPos> allNodesPos = isolator.allNodes;
            Set<BlockEntityTransformer> availableTransformers = allNodesPos.stream().filter(x -> this.f_58857_.m_7702_(x.m_7495_()) instanceof BlockEntityTransformer).map(x -> (BlockEntityTransformer)this.f_58857_.m_7702_(x.m_7495_())).filter(Objects::nonNull).filter(x -> x.isMaster() && x.extract()).collect(Collectors.toSet());
            if (availableTransformers.isEmpty()) {
                return 0;
            }
            int realMaxEnergy = Math.min(TRANSFER_SPEED, energy);
            Set<CapPercentage> percentages = this.calculatePercentage(availableTransformers, realMaxEnergy);
            for (CapPercentage entry : percentages) {
                float percentage = entry.getPercentage();
                BlockEntityTransformer transformer = (BlockEntityTransformer)entry.getBlockEntity();
                int individualAmount = entry.getAmount();
                int energyCalculated = (int)((float)individualAmount * percentage);
                if (energyCalculated <= 0) continue;
                int energyOut = transformer.outPutEnergy(energyCalculated, simulate);
                out += energyOut;
            }
        }
        if (!simulate) {
            this.energyOverTime += out;
        }
        return out;
    }

    private Set<CapPercentage> calculatePercentage(Set<BlockEntityTransformer> availableTransformers, int energy) {
        int totalEnergyUsed = 0;
        int validOutputs = 0;
        HashSet<CapPercentage> percentages = new HashSet<CapPercentage>();
        if (availableTransformers.size() == 1) {
            percentages.add(new CapPercentage((IEnergyStorage)null, (BlockEntity)availableTransformers.iterator().next(), 1.0f, energy));
            return percentages;
        }
        for (BlockEntityTransformer transformer : availableTransformers) {
            int amount;
            if (transformer == null || (amount = transformer.outPutEnergy(energy, true)) <= 0) continue;
            totalEnergyUsed += amount;
            ++validOutputs;
            percentages.add(new CapPercentage((IEnergyStorage)null, (BlockEntity)transformer, 1.0f, amount));
        }
        if (totalEnergyUsed <= energy || validOutputs == 0 || totalEnergyUsed == 0) {
            return percentages;
        }
        float bestRatio = Utils.normalize(energy, 0.0f, totalEnergyUsed);
        for (CapPercentage entry : percentages) {
            float actualPercentage = entry.getPercentage();
            if (!(actualPercentage > 0.0f)) continue;
            entry.setPercentage(actualPercentage * bestRatio);
        }
        return percentages;
    }

    private int outPutEnergy(int energy, boolean simulate) {
        IEnergyStorage teEnergyStorage;
        BlockPos targetLocation = this.f_58858_.m_7495_().m_5484_(this.getFacing().m_122424_(), 2);
        BlockEntity te = this.f_58857_.m_7702_(targetLocation);
        if (te != null && (teEnergyStorage = (IEnergyStorage)te.getCapability(ForgeCapabilities.ENERGY, this.getFacing()).orElse(null)) != null) {
            int amount = teEnergyStorage.receiveEnergy(Math.min(TRANSFER_SPEED, energy), simulate);
            if (!simulate) {
                this.energyOverTime += amount;
            }
            return amount;
        }
        return 0;
    }

    private boolean hasIsolator() {
        if (this.f_58857_ == null) {
            return false;
        }
        return this.f_58857_.m_7702_(this.f_58858_.m_7494_()) instanceof BlockEntityHVIsolator;
    }

    private BlockEntityHVIsolator getIsolator() {
        if (this.f_58857_ == null) {
            return null;
        }
        BlockEntity TE = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
        if (TE instanceof BlockEntityHVIsolator) {
            return (BlockEntityHVIsolator)TE;
        }
        return null;
    }

    public String getGenerationText() {
        return (this.extract() ? "IN" : "OUT") + " " + this.averageEnergy + " FE/t";
    }

    public float getGenerationFill() {
        float currentAmount = this.averageEnergy;
        float totalCapacity = TRANSFER_SPEED;
        return (currentAmount /= totalCapacity) * 90.0f;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        BlockPos masterPos;
        Direction masterFacing = this.getFacing();
        BlockPos blockPos = masterPos = this.masterPos != null ? this.masterPos : this.f_58858_;
        if (side == null) {
            return super.getCapability(cap, side);
        }
        if (cap == ForgeCapabilities.ENERGY && this.f_58858_.equals((Object)masterPos.m_7495_().m_121945_(masterFacing.m_122424_())) && side == masterFacing.m_122424_() && this.getMaster() != null) {
            if (((BlockEntityTransformer)this.getMaster()).extract()) {
                return ((BlockEntityTransformer)this.getMaster()).dummyHandler.cast();
            }
            return ((BlockEntityTransformer)this.getMaster()).energyStorageHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        compoundTag.m_128405_("energy", this.averageEnergy);
        super.m_183515_(compoundTag);
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        this.averageEnergy = compoundTag.m_128451_("energy");
        super.m_142466_(compoundTag);
    }
}

