/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity;

import javax.annotation.Nonnull;
import net.cassiokf.industrialrenewal.block.BlockWindTurbineHead;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntitySyncable;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.item.ItemWindBlade;
import net.cassiokf.industrialrenewal.util.capability.CustomEnergyStorage;
import net.cassiokf.industrialrenewal.util.capability.CustomItemStackHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public class BlockEntityWindTurbineHead
extends BlockEntitySyncable {
    public static int energyGeneration = 128;
    private static final CustomEnergyStorage energyStorage = new CustomEnergyStorage(energyGeneration, energyGeneration, energyGeneration).noReceive().noExtraction();
    private static final LazyOptional<IEnergyStorage> energyStorageHandler = LazyOptional.of(() -> energyStorage);
    private final LazyOptional<IItemHandler> bladeInv = LazyOptional.of(this::createHandler);
    private float rotation;
    private float oldRotation = -1.0f;
    private int energyGenerated;
    private int tickToDamage;

    public BlockEntityWindTurbineHead(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.WIND_TURBINE_TILE.get(), pos, state);
    }

    private IItemHandler createHandler() {
        return new CustomItemStackHandler(1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.m_41720_() instanceof ItemWindBlade;
            }

            @Override
            protected void onContentsChanged(int slot) {
                BlockEntityWindTurbineHead.this.sync();
            }
        };
    }

    public void dropContents() {
        if (this.f_58857_ == null) {
            return;
        }
        this.bladeInv.ifPresent(inv -> Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)inv.getStackInSlot(0)));
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.m_5776_()) {
            this.handleServerSideTick();
        } else {
            this.handleClientSideTick();
        }
    }

    private void handleServerSideTick() {
        if (this.hasBlade()) {
            this.generateEnergy();
            this.handleBladeDamage();
        } else {
            this.energyGenerated = 0;
        }
    }

    private void generateEnergy() {
        IEnergyStorage downE;
        BlockEntity te;
        int energyGen = Math.round((float)energyGeneration * this.getEfficiency());
        if (energyGen > 0 && (te = this.f_58857_.m_7702_(this.f_58858_.m_7495_())) != null && (downE = (IEnergyStorage)te.getCapability(ForgeCapabilities.ENERGY, Direction.UP).orElse(null)) != null && downE.canReceive()) {
            downE.receiveEnergy(energyGen, false);
        }
    }

    private void handleBladeDamage() {
        if (++this.tickToDamage >= 1200 && this.energyGenerated > 0) {
            this.tickToDamage = 0;
            this.bladeInv.ifPresent(inv -> {
                ItemStack stack = inv.getStackInSlot(0);
                if (!stack.m_41619_() && stack.m_220157_(1, this.m_58904_().f_46441_, null)) {
                    stack.m_41774_(1);
                }
            });
        }
    }

    private void handleClientSideTick() {
        if (this.hasBlade()) {
            this.oldRotation = this.rotation;
            this.rotation += 6.0f * Math.max(0.1f, this.getEfficiency());
            if (this.rotation >= 360.0f) {
                this.rotation -= 360.0f;
                this.oldRotation -= 360.0f;
            }
        }
    }

    public IItemHandler getBladeHandler() {
        return (IItemHandler)this.bladeInv.orElse(null);
    }

    public float getRotation() {
        return this.rotation;
    }

    public float getOldRotation() {
        return this.oldRotation;
    }

    public boolean hasBlade() {
        if (this.bladeInv.isPresent()) {
            IItemHandler iItemHandler = (IItemHandler)this.bladeInv.orElse(null);
            return !iItemHandler.getStackInSlot(0).m_41619_();
        }
        return false;
    }

    private float getEfficiency() {
        if (this.f_58857_ == null) {
            return 0.0f;
        }
        float weatherModifier = this.f_58857_.m_46470_() ? 2.0f : (this.f_58857_.m_46471_() ? 1.5f : 1.0f);
        float posMin = -2040.0f;
        float heightModifier = this.f_58858_.m_123342_() - 62 <= 0 ? 0.1f : ((float)this.f_58858_.m_123342_() - posMin) / (255.0f - posMin);
        heightModifier = Mth.m_14036_((float)heightModifier, (float)0.0f, (float)1.0f);
        return weatherModifier * heightModifier;
    }

    public Direction getBlockFacing() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockWindTurbineHead.FACING);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.bladeInv.cast();
        }
        if (capability == ForgeCapabilities.ENERGY && facing == Direction.DOWN) {
            return energyStorageHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        compoundTag.m_128405_("energy", energyStorage.getEnergyStored());
        this.bladeInv.ifPresent(h -> {
            CompoundTag tag = (CompoundTag)((INBTSerializable)h).serializeNBT();
            compoundTag.m_128365_("inv", (Tag)tag);
        });
        compoundTag.m_128405_("generation", this.energyGenerated);
        compoundTag.m_128405_("damageTick", this.tickToDamage);
        super.m_183515_(compoundTag);
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        energyStorage.setEnergy(compoundTag.m_128451_("energy"));
        CompoundTag invTag = compoundTag.m_128469_("inv");
        this.bladeInv.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((Tag)invTag));
        this.energyGenerated = compoundTag.m_128451_("generation");
        this.tickToDamage = compoundTag.m_128451_("damageTick");
        super.m_142466_(compoundTag);
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

