/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity.abstracts;

import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntityMultiBlocksTube;
import net.cassiokf.industrialrenewal.obj.CapResult;
import net.cassiokf.industrialrenewal.util.PipeUtils;
import net.cassiokf.industrialrenewal.util.Utils;
import net.cassiokf.industrialrenewal.util.capability.CustomEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public abstract class BlockEntityEnergyCable
extends BlockEntityMultiBlocksTube<BlockEntityEnergyCable>
implements ICapabilityProvider {
    private int averageEnergy;
    private int potentialEnergy;
    public final CustomEnergyStorage energyStorage = new CustomEnergyStorage(this.getMaxEnergyToTransport(), this.getMaxEnergyToTransport(), this.getMaxEnergyToTransport()){

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (maxReceive <= 0) {
                return 0;
            }
            return BlockEntityEnergyCable.this.onEnergyReceived(maxReceive, simulate);
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }
    };
    public final LazyOptional<CustomEnergyStorage> energyStorageHandler = LazyOptional.of(() -> this.energyStorage);
    private int oldPotential = -1;
    private int oldEnergy;
    private int tick;

    public BlockEntityEnergyCable(BlockEntityType<?> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
    }

    @Override
    public void doTick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.isMaster()) {
            if (this.tick >= 10) {
                this.tick = 0;
                this.averageEnergy = this.outPut / 10;
                this.outPut = 0;
                if (this.averageEnergy != this.oldEnergy || this.potentialEnergy != this.oldPotential) {
                    this.oldPotential = this.potentialEnergy;
                    this.oldEnergy = this.averageEnergy;
                    this.sync();
                }
            }
            ++this.tick;
        }
    }

    public int onEnergyReceived(int energy, boolean simulate) {
        if (!this.isMaster() || this.f_58857_.f_46443_) {
            return 0;
        }
        if (this.inUse) {
            return 0;
        }
        if (energy <= 0) {
            return 0;
        }
        this.inUse = true;
        int maxTransfer = Math.min(energy, this.getMaxEnergyToTransport());
        if (!simulate) {
            this.potentialEnergy = maxTransfer;
        }
        CapResult result = PipeUtils.moveEnergy(this, maxTransfer, this.getMaxEnergyToTransport(), simulate);
        if (!simulate) {
            this.outPut += result.getOutPut();
        }
        this.outPutCount = result.getValidReceivers();
        this.inUse = false;
        return result.getOutPut();
    }

    @Override
    public void checkForOutPuts(BlockPos bPos) {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        for (Direction face : Direction.values()) {
            boolean hasMachine;
            BlockPos currentPos = this.f_58858_.m_121945_(face);
            BlockEntity te = this.f_58857_.m_7702_(currentPos);
            boolean bl = hasMachine = te != null && !(te instanceof BlockEntityEnergyCable) && te.getCapability(ForgeCapabilities.ENERGY, face.m_122424_()).isPresent();
            if (!hasMachine || !((IEnergyStorage)te.getCapability(ForgeCapabilities.ENERGY, face.m_122424_()).orElse(null)).canReceive()) continue;
            if (!this.isMasterInvalid()) {
                ((BlockEntityEnergyCable)((Object)this.getMaster())).addReceiver(te, face);
                continue;
            }
            if (this.isMasterInvalid()) continue;
            ((BlockEntityEnergyCable)((Object)this.getMaster())).removeReceiver(te);
        }
        ((BlockEntityEnergyCable)((Object)this.getMaster())).cleanReceiversContainer();
    }

    public void invalidateCaps() {
        this.energyStorageHandler.invalidate();
        super.invalidateCaps();
    }

    public abstract int getMaxEnergyToTransport();

    public String GetText() {
        return Utils.formatPreciseEnergyString(((BlockEntityEnergyCable)((Object)this.getMaster())).averageEnergy);
    }

    public float getOutPutAngle() {
        return Utils.normalizeClamped(((BlockEntityEnergyCable)((Object)this.getMaster())).averageEnergy, 0.0f, this.getMaxEnergyToTransport()) * 90.0f;
    }

    public Direction getBlockFacing() {
        return Direction.NORTH;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (facing == null) {
            return super.getCapability(capability, facing);
        }
        if (capability == ForgeCapabilities.ENERGY && this.getMaster() != null) {
            return ((BlockEntityEnergyCable)((Object)this.getMaster())).energyStorageHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void m_183515_(CompoundTag compoundTag) {
        compoundTag.m_128405_("energy", this.averageEnergy);
        super.m_183515_(compoundTag);
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        this.averageEnergy = compoundTag.m_128451_("energy");
        super.m_142466_(compoundTag);
    }
}

