/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity.abstracts;

import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntityMultiBlocksTube;
import net.cassiokf.industrialrenewal.obj.CapResult;
import net.cassiokf.industrialrenewal.util.PipeUtils;
import net.cassiokf.industrialrenewal.util.capability.CustomFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockEntityFluidPipeBase<T extends BlockEntityFluidPipeBase<?>>
extends BlockEntityMultiBlocksTube<T>
implements ICapabilityProvider {
    public int averageFluid;
    private int maxOutput;
    private final CustomFluidTank tank;
    private final LazyOptional<CustomFluidTank> tankHandler;
    private int oldFluid;
    private int tick;

    public BlockEntityFluidPipeBase(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state, int maxOutput) {
        super(tileEntityTypeIn, pos, state);
        this.tank = new CustomFluidTank(this.maxOutput){

            @Override
            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                return BlockEntityFluidPipeBase.this.onFluidReceived(resource, action);
            }
        }.setBlockEntity(this);
        this.tankHandler = LazyOptional.of(this::getTank);
        this.maxOutput = maxOutput;
    }

    @Override
    public void doTick() {
        if (!this.f_58857_.f_46443_ && this.isMaster()) {
            if (this.tick >= 10) {
                this.tick = 0;
                this.averageFluid = this.outPut / 10;
                this.outPut = 0;
                if (this.averageFluid != this.oldFluid) {
                    this.oldFluid = this.averageFluid;
                    this.sync();
                }
            }
            ++this.tick;
        }
    }

    public CustomFluidTank getTank() {
        return this.tank;
    }

    public int onFluidReceived(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.isMaster() && !this.isMasterInvalid()) {
            return ((BlockEntityFluidPipeBase)((Object)this.getMaster())).onFluidReceived(resource, action);
        }
        if (this.inUse) {
            return 0;
        }
        if (resource == null || resource.getAmount() <= 0) {
            return 0;
        }
        this.inUse = true;
        CapResult result = PipeUtils.outputFluid(this, resource, this.maxOutput, action, this.f_58857_);
        if (action.equals((Object)IFluidHandler.FluidAction.EXECUTE)) {
            this.outPut += result.getOutPut();
        }
        this.outPutCount = result.getValidReceivers();
        this.inUse = false;
        return result.getOutPut();
    }

    @Override
    public void checkForOutPuts(BlockPos bPos) {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            for (Direction face : Direction.values()) {
                boolean canReceive;
                BlockPos currentPos = this.f_58858_.m_121945_(face);
                BlockEntity te = this.f_58857_.m_7702_(currentPos);
                boolean hasMachine = te != null && !(te instanceof BlockEntityFluidPipeBase);
                IFluidHandler fh = te != null ? (IFluidHandler)te.getCapability(ForgeCapabilities.FLUID_HANDLER, face.m_122424_()).orElse(null) : null;
                boolean bl = canReceive = fh != null && fh.getTankCapacity(0) > 0;
                if (canReceive && fh instanceof CustomFluidTank) {
                    CustomFluidTank cf = (CustomFluidTank)fh;
                    canReceive = cf.canFill();
                }
                if (hasMachine && canReceive) {
                    if (this.isMasterInvalid()) continue;
                    ((BlockEntityFluidPipeBase)((Object)this.getMaster())).addReceiver(te, face);
                    continue;
                }
                if (this.isMasterInvalid()) continue;
                ((BlockEntityFluidPipeBase)((Object)this.getMaster())).removeReceiver(te);
            }
            ((BlockEntityFluidPipeBase)((Object)this.getMaster())).cleanReceiversContainer();
        }
    }

    public void invalidateCaps() {
        this.tankHandler.invalidate();
        super.invalidateCaps();
    }

    @NotNull
    public <E> LazyOptional<E> getCapability(@NotNull Capability<E> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER && this.getMaster() != null) {
            return LazyOptional.of(() -> ((BlockEntityFluidPipeBase)((Object)((Object)this.getMaster()))).getTank()).cast();
        }
        return super.getCapability(capability, facing);
    }

    @NotNull
    public <E> LazyOptional<E> getCapability(@NotNull Capability<E> cap) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && this.getMaster() != null) {
            return LazyOptional.of(() -> ((BlockEntityFluidPipeBase)((Object)((Object)this.getMaster()))).getTank()).cast();
        }
        return super.getCapability(cap);
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        compound.m_128405_("fluid", this.averageFluid);
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.averageFluid = compound.m_128451_("fluid");
        super.m_142466_(compound);
    }

    @Override
    public boolean instanceOf(BlockEntity te) {
        return te instanceof BlockEntityFluidPipeBase;
    }
}

