/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity.abstracts;

import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BETubeBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BlockEntityMultiBlocksTube<TE extends BlockEntityMultiBlocksTube<?>>
extends BETubeBase {
    public final Map<BlockEntity, Integer> limitedOutPutMap = new ConcurrentHashMap<BlockEntity, Integer>();
    private final Map<BlockEntity, Direction> receiversContainer = new ConcurrentHashMap<BlockEntity, Direction>();
    private final Map<BlockEntity, Direction> receiversPressurizedContainer = new ConcurrentHashMap<BlockEntity, Direction>();
    public int outPut;
    public int oldOutPut = -1;
    public int outPutCount;
    public TE master;
    public boolean isMaster;
    public boolean firstTick;
    public boolean inUse = false;
    protected boolean startBreaking;
    int oldOutPutCount = -1;

    public BlockEntityMultiBlocksTube(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public void tick() {
        if (!this.firstTick && this.m_58898_()) {
            this.firstTick = true;
            this.beforeInitialize();
            this.initializeMultiblockIfNecessary(true);
            this.onFirstLoad();
        }
        this.limitedOutPutMap.clear();
        if (this.m_58898_() && !this.m_58901_()) {
            this.doTick();
        }
    }

    public void beforeInitialize() {
    }

    public void doTick() {
    }

    public void onFirstLoad() {
    }

    private void initializeMultiblockIfNecessary() {
        this.initializeMultiblockIfNecessary(false);
    }

    private void initializeMultiblockIfNecessary(boolean forceInit) {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.isTray()) {
            return;
        }
        if (this.isMasterInvalid() && !this.m_58901_() || forceInit) {
            CopyOnWriteArrayList<BlockEntityMultiBlocksTube> connectedCables = new CopyOnWriteArrayList<BlockEntityMultiBlocksTube>();
            Stack<BlockEntityMultiBlocksTube> traversingCables = new Stack<BlockEntityMultiBlocksTube>();
            BlockEntityMultiBlocksTube master = this;
            traversingCables.add(this);
            while (!traversingCables.isEmpty()) {
                BlockEntityMultiBlocksTube storage = (BlockEntityMultiBlocksTube)((Object)traversingCables.pop());
                if (storage.isMaster()) {
                    master = storage;
                }
                connectedCables.add(storage);
                for (Direction d : this.getFacesToCheck()) {
                    BlockEntity te = this.f_58857_.m_7702_(storage.m_58899_().m_121945_(d));
                    if (!this.instanceOf(te) || connectedCables.contains(te)) continue;
                    traversingCables.add((BlockEntityMultiBlocksTube)te);
                }
            }
            master.getReceivers().clear();
            master.getReceiversContainers().clear();
            master.getReceiversPressurizedContainer().clear();
            if (this.canBeMaster(master)) {
                for (BlockEntityMultiBlocksTube storage : connectedCables) {
                    if (!this.canBeMaster(storage)) continue;
                    storage.setMaster(master);
                    storage.checkForOutPuts(storage.m_58899_());
                    storage.m_6596_();
                }
            } else {
                for (BlockEntityMultiBlocksTube storage : connectedCables) {
                    if (!this.canBeMaster(storage)) continue;
                    storage.getReceivers().clear();
                    storage.setMaster(null);
                }
            }
            this.m_6596_();
        }
    }

    public void requestModelRefresh() {
        this.requestModelDataUpdate();
    }

    public boolean isTray() {
        return false;
    }

    public boolean canBeMaster(BlockEntity te) {
        return te != null;
    }

    public boolean isMasterInvalid() {
        return this.master == null || this.master.m_58901_();
    }

    public Direction[] getFacesToCheck() {
        return Direction.values();
    }

    public abstract boolean instanceOf(BlockEntity var1);

    public abstract void checkForOutPuts(BlockPos var1);

    public boolean isMaster() {
        return this.isMaster;
    }

    public TE getMaster() {
        this.initializeMultiblockIfNecessary();
        if (this.master != null && !((BlockEntityMultiBlocksTube)((Object)this.master)).isMaster()) {
            this.sync();
        }
        if (this.master == null) {
            if (this.f_58857_.m_5776_() || !this.startBreaking) {
                // empty if block
            }
            return (TE)((Object)this);
        }
        return this.master;
    }

    public void setMaster(TE nMaster) {
        boolean wasMaster = this.isMaster;
        TE oldMaster = this.master;
        this.master = nMaster;
        boolean bl = this.isMaster = nMaster == this;
        if (wasMaster != this.isMaster) {
            this.sync();
        }
        if (oldMaster != null) {
            ((BlockEntityMultiBlocksTube)((Object)oldMaster)).master = nMaster;
            if (oldMaster != nMaster) {
                ((BlockEntityMultiBlocksTube)((Object)oldMaster)).isMaster = false;
            }
        }
        if (!this.isMaster) {
            this.receiversContainer.clear();
        }
    }

    public int getLimitedValueForOutPut(int value, int maxTransferAmount, BlockEntity storage, boolean simulate) {
        if (!this.limitedOutPutMap.containsKey(storage)) {
            if (!simulate) {
                this.limitedOutPutMap.put(storage, value);
            }
            return Math.min(value, maxTransferAmount);
        }
        int currentValue = this.limitedOutPutMap.get(storage);
        int maxValue = maxTransferAmount - currentValue;
        maxValue = Math.min(value, maxValue);
        if (!simulate) {
            this.limitedOutPutMap.put(storage, currentValue + maxValue);
        }
        return maxValue;
    }

    public Map<BlockEntity, Direction> getReceiversContainers() {
        return this.receiversContainer;
    }

    public Map<BlockEntity, Direction> getReceiversPressurizedContainer() {
        return this.receiversPressurizedContainer;
    }

    public void cleanReceiversContainer() {
        Set toRemove = this.receiversContainer.keySet().stream().filter(BlockEntity::m_58901_).collect(Collectors.toSet());
        for (BlockEntity be : toRemove) {
            this.receiversContainer.remove(be);
        }
    }

    public void cleanReceiversPressurizedContainer() {
        Set toRemove = this.receiversPressurizedContainer.keySet().stream().filter(BlockEntity::m_58901_).collect(Collectors.toSet());
        for (BlockEntity be : toRemove) {
            this.receiversPressurizedContainer.remove(be);
        }
    }

    public void addReceiver(BlockEntity machine, Direction face) {
        if (machine == null) {
            return;
        }
        if (!this.isMaster()) {
            ((BlockEntityMultiBlocksTube)((Object)this.getMaster())).addReceiver(machine, face);
            return;
        }
        if (machine.m_58904_().m_5776_() || this.receiversContainer.containsKey(machine)) {
            return;
        }
        this.receiversContainer.put(machine, face);
    }

    public void removeReceiver(BlockEntity machine) {
        if (this.startBreaking || this.m_58901_() || machine == null) {
            return;
        }
        if (!this.isMaster()) {
            ((BlockEntityMultiBlocksTube)((Object)this.getMaster())).removeReceiver(machine);
            return;
        }
        this.receiversContainer.remove(machine);
    }

    public Map<BlockEntity, Direction> getReceivers() {
        return this.receiversContainer;
    }

    public void addReceiverPressurized(BlockEntity machine, Direction face) {
        if (machine == null) {
            return;
        }
        if (!this.isMaster()) {
            ((BlockEntityMultiBlocksTube)((Object)this.getMaster())).addReceiver(machine, face);
            return;
        }
        if (machine.m_58904_().m_5776_() || this.receiversPressurizedContainer.containsKey(machine)) {
            return;
        }
        this.receiversPressurizedContainer.put(machine, face);
    }

    public void removeReceiverPressurized(BlockEntity machine) {
        if (this.startBreaking || this.m_58901_() || machine == null) {
            return;
        }
        if (!this.isMaster()) {
            ((BlockEntityMultiBlocksTube)((Object)this.getMaster())).removeReceiver(machine);
            return;
        }
        this.receiversPressurizedContainer.remove(machine);
    }

    public void startBreaking() {
        this.startBreaking = true;
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.master != null) {
            ((BlockEntityMultiBlocksTube)((Object)this.master)).setMaster(null);
        }
    }

    public void breakBlock() {
        if (this.f_58857_ == null) {
            return;
        }
        this.startBreaking = true;
        this.m_7651_();
        if (this.master != null) {
            ((BlockEntityMultiBlocksTube)((Object)this.master)).getMaster();
        } else if (!this.isMaster) {
            this.getMaster();
        }
        for (Direction d : Direction.values()) {
            BlockEntity te = this.f_58857_.m_7702_(this.m_58899_().m_121945_(d));
            if (!(te instanceof BlockEntityMultiBlocksTube)) continue;
            ((BlockEntityMultiBlocksTube)te).master = null;
            ((BlockEntityMultiBlocksTube)te).initializeMultiblockIfNecessary();
        }
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.isMaster = compound.m_128471_("isMaster");
        this.outPut = compound.m_128451_("out");
        this.outPutCount = compound.m_128451_("count");
        super.m_142466_(compound);
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        compound.m_128379_("isMaster", this.isMaster);
        compound.m_128405_("out", this.outPut);
        compound.m_128405_("count", this.outPutCount);
        super.m_183515_(compound);
    }
}

