/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity.abstracts;

import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntitySyncable;
import net.cassiokf.industrialrenewal.config.Config;
import net.cassiokf.industrialrenewal.util.Utils;
import net.cassiokf.industrialrenewal.util.capability.CustomEnergyStorage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidGenerator {
    public static int energyPerTick = 32;
    private final BlockEntitySyncable attachedTE;
    public final CustomEnergyStorage energyStorage = new CustomEnergyStorage(128, 128, energyPerTick){

        @Override
        public void onEnergyChange() {
            FluidGenerator.this.sync();
        }

        @Override
        public boolean canReceive() {
            return false;
        }
    };
    public final LazyOptional<CustomEnergyStorage> energyHandler = LazyOptional.of(() -> this.energyStorage);
    private final int TANK_CAPACITY = 8000;
    public final FluidTank tank = new FluidTank(8000){

        protected void onContentsChanged() {
            super.onContentsChanged();
            FluidGenerator.this.sync();
        }

        public boolean isFluidValid(FluidStack stack) {
            return Config.getFuelHash().get(stack.getFluid().getFluidType().getDescription(stack).toString()) != null;
        }
    };
    public final LazyOptional<FluidTank> tankHandler = LazyOptional.of(() -> this.tank);
    private boolean canGenerate = false;
    private boolean isGenerating = false;
    private boolean oldRunning = false;
    private int fuelTime = 0;

    public FluidGenerator(BlockEntitySyncable te) {
        this.attachedTE = te;
    }

    public void invalidate() {
        this.tankHandler.invalidate();
        this.energyHandler.invalidate();
    }

    public void onTick() {
        if (this.canGenerate) {
            this.updateLiquidFuel();
            if (this.fuelTime > 0) {
                this.isGenerating = true;
                this.energyStorage.addEnergy(energyPerTick);
                --this.fuelTime;
            } else {
                this.isGenerating = false;
            }
        } else {
            this.isGenerating = false;
        }
        if (this.isGenerating != this.oldRunning) {
            this.oldRunning = this.isGenerating;
            this.sync();
        }
    }

    private void updateLiquidFuel() {
        if (this.fuelTime > 0) {
            return;
        }
        FluidStack resource = this.tank.getFluid();
        if (resource.getAmount() <= 0) {
            return;
        }
        int fuel = resource.getAmount();
        if (fuel > 0) {
            int amount = Math.min(1000, resource.getAmount());
            float norm = Utils.normalizeClamped(amount, 0.0f, 1000.0f);
            this.fuelTime = Config.getFuelHash().get(resource.getTranslationKey()) != null ? Config.getFuelHash().get(resource.getDisplayName().toString()) : 0;
            this.tank.drain(amount, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public boolean isGenerating() {
        return this.isGenerating;
    }

    public String getTankContent() {
        return this.tank.getFluid().getTranslationKey();
    }

    public int getTankAmount() {
        return this.tank.getFluidAmount();
    }

    public int getGenerateAmount() {
        return energyPerTick;
    }

    public CompoundTag saveGenerator(CompoundTag compound) {
        compound.m_128405_("FGenerator", this.fuelTime);
        compound.m_128379_("running", this.isGenerating);
        compound.m_128379_("generate", this.canGenerate);
        compound.m_128405_("energy", this.energyStorage.getEnergyStored());
        compound.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        return compound;
    }

    public void loadGenerator(CompoundTag compound) {
        this.fuelTime = compound.m_128451_("FGenerator");
        this.isGenerating = compound.m_128471_("running");
        this.canGenerate = compound.m_128471_("generate");
        this.energyStorage.setEnergy(compound.m_128451_("energy"));
        this.tank.readFromNBT(compound.m_128469_("tank"));
    }

    public void setCanGenerate(boolean value) {
        this.canGenerate = value;
    }

    public void changeCanGenerate() {
        this.canGenerate = !this.canGenerate;
    }

    public void sync() {
        this.attachedTE.sync();
    }

    public void setChanged() {
        this.attachedTE.m_6596_();
    }
}

