/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity.dam;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.block.abstracts.BlockAbstractHorizontalFacing;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntitySyncable;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.util.capability.CustomPressureFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockEntityDamOutlet
extends BlockEntitySyncable {
    public static final int MAX_PROCESSING = 10000;
    private boolean hasFlow = false;
    private final CustomPressureFluidTank tank = new CustomPressureFluidTank(10000){

        @Override
        public int receiveCompressedFluid(int amount, int y, IFluidHandler.FluidAction action) {
            return BlockEntityDamOutlet.this.passCompressedFluid(amount, y, action);
        }

        @Override
        public boolean canDrain() {
            return false;
        }

        @Override
        public boolean canFill() {
            return false;
        }
    };
    private boolean removed = true;
    private Direction blockFacing;
    private int tick;

    public BlockEntityDamOutlet(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.DAM_OUTLET.get(), pos, state);
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            if (this.tick % 20 == 0) {
                this.tick = 0;
                BlockState state = this.f_58857_.m_8055_(this.f_58858_.m_121945_(this.getBlockFacing()));
                if (this.hasFlow) {
                    if (this.removed && !state.m_60819_().m_76170_() && !state.m_60734_().equals(Blocks.f_49990_)) {
                        BlockState waterState = Blocks.f_49990_.m_49966_();
                        this.f_58857_.m_46597_(this.f_58858_.m_121945_(this.getBlockFacing()), waterState);
                        this.removed = false;
                    }
                } else if (!this.removed && (state.m_60819_().m_76170_() || state.m_60734_().equals(Blocks.f_49990_))) {
                    this.f_58857_.m_46597_(this.f_58858_.m_121945_(this.getBlockFacing()), Blocks.f_50016_.m_49966_());
                    this.removed = true;
                }
                this.hasFlow = false;
            }
            ++this.tick;
        }
    }

    public int passCompressedFluid(int amount, int y, IFluidHandler.FluidAction action) {
        int height = y - this.f_58858_.m_123342_();
        this.hasFlow = action.equals((Object)IFluidHandler.FluidAction.EXECUTE) && amount >= 0 && height >= 0;
        return height >= 0 ? amount : 0;
    }

    public Direction getBlockFacing() {
        if (this.blockFacing != null) {
            return this.blockFacing;
        }
        return this.forceFaceCheck();
    }

    public Direction forceFaceCheck() {
        this.blockFacing = (Direction)this.m_58900_().m_61143_((Property)BlockAbstractHorizontalFacing.FACING);
        return this.blockFacing;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        Direction facing = this.getBlockFacing();
        if (side == null) {
            return super.getCapability(cap, side);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && side.equals((Object)facing.m_122424_())) {
            return LazyOptional.of(() -> this.tank).cast();
        }
        return super.getCapability(cap, side);
    }
}

