/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity.dam;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.block.dam.BlockDamGenerator;
import net.cassiokf.industrialrenewal.block.dam.BlockRotationalShaft;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntity3x3x3MachineBase;
import net.cassiokf.industrialrenewal.blockentity.dam.BlockEntityDamGenerator;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.util.Utils;
import net.cassiokf.industrialrenewal.util.capability.CustomFluidTank;
import net.cassiokf.industrialrenewal.util.capability.CustomPressureFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockEntityDamTurbine
extends BlockEntity3x3x3MachineBase<BlockEntityDamTurbine> {
    public static int MAX_PROCESSING = 1000;
    public static int MAX_EFFICIENCY = 10000;
    public final CustomFluidTank dummyTank = new CustomFluidTank(0);
    public final LazyOptional<CustomFluidTank> dummyHandler = LazyOptional.of(() -> this.dummyTank);
    private float oldRotation;
    private float rotation;
    private int passedFluid = 0;
    private boolean hasFlow = false;
    public final CustomPressureFluidTank inTank = new CustomPressureFluidTank(){

        @Override
        public int receiveCompressedFluid(int amount, int y, IFluidHandler.FluidAction action) {
            return BlockEntityDamTurbine.this.passCompressedFluid(amount, y, action);
        }
    };
    public final LazyOptional<CustomPressureFluidTank> inTankHandler = LazyOptional.of(() -> this.inTank);

    public BlockEntityDamTurbine(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.DAM_TURBINE_TILE.get(), pos, state);
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.isMaster() && !this.f_58857_.f_46443_) {
            this.doRotation();
            this.passRotation();
        }
    }

    private void passRotation() {
        if (this.f_58857_ == null) {
            return;
        }
        BlockPos top = this.f_58858_.m_6630_(2);
        for (int i = 0; i < 16; ++i) {
            if (this.f_58857_.m_8055_(top).m_60734_() instanceof BlockDamGenerator) {
                BlockEntity te = this.f_58857_.m_7702_(top.m_7494_());
                if (!(te instanceof BlockEntityDamGenerator) || !((BlockEntityDamGenerator)te).isMaster()) break;
                BlockEntityDamGenerator generatorTE = (BlockEntityDamGenerator)this.f_58857_.m_7702_(top.m_7494_());
                generatorTE.updateRotation((int)this.rotation);
                break;
            }
            if (!(this.f_58857_.m_8055_(top).m_60734_() instanceof BlockRotationalShaft)) break;
            top = top.m_7494_();
        }
    }

    public int passCompressedFluid(int amount, int y, IFluidHandler.FluidAction action) {
        IFluidHandler tank;
        if (this.f_58857_ == null) {
            return 0;
        }
        if (!this.isMaster()) {
            return ((BlockEntityDamTurbine)((Object)this.getMaster())).passCompressedFluid(amount, y, action);
        }
        int height = y - this.f_58858_.m_123342_();
        if (height < 0) {
            return 0;
        }
        int realAmount = 0;
        Direction masterFace = this.getMasterFacing();
        BlockPos outPutPos = ((BlockEntityDamTurbine)((Object)this.getMaster())).m_58899_().m_5484_(masterFace.m_122428_(), 2).m_121945_(masterFace.m_122424_()).m_7495_();
        BlockEntity te = this.f_58857_.m_7702_(outPutPos);
        if (te != null && (tank = (IFluidHandler)te.getCapability(ForgeCapabilities.FLUID_HANDLER, masterFace.m_122427_()).orElse(null)) != null && tank instanceof CustomPressureFluidTank) {
            CustomPressureFluidTank cc = (CustomPressureFluidTank)tank;
            realAmount = cc.receiveCompressedFluid(amount, this.f_58858_.m_123342_(), action);
        }
        this.passedFluid = realAmount;
        if (action.equals((Object)IFluidHandler.FluidAction.EXECUTE) && realAmount > 0) {
            this.hasFlow = true;
        }
        return realAmount;
    }

    private void rotationDecay() {
        this.rotation *= 0.995f;
        this.rotation -= 0.05f;
        this.rotation = Mth.m_14036_((float)this.rotation, (float)0.0f, (float)MAX_PROCESSING);
        if (this.rotation != this.oldRotation) {
            this.oldRotation = this.rotation;
            this.sync();
        }
    }

    private void doRotation() {
        float norm = Utils.normalizeClamped(this.passedFluid, 0.0f, MAX_EFFICIENCY);
        if (this.hasFlow) {
            float max = (float)MAX_PROCESSING * norm;
            if (Float.isNaN(this.rotation)) {
                this.rotation = 0.0f;
            }
            if (this.rotation < max) {
                float clamped = Utils.normalizeClamped(this.rotation, 0.001f, norm);
                this.rotation *= 1.0f + 0.005f / clamped;
                this.rotation += Math.min(norm * 0.05f, max - this.rotation);
            } else if (this.rotation > max) {
                this.rotation -= 1.0f;
            }
        } else if (this.rotation > 0.0f) {
            this.rotationDecay();
        }
        this.rotation = Mth.m_14036_((float)this.rotation, (float)0.0f, (float)6000.0f);
        if (this.rotation != this.oldRotation) {
            this.oldRotation = this.rotation;
            this.sync();
        }
        this.hasFlow = false;
    }

    @Override
    public boolean instanceOf(BlockEntity tileEntity) {
        return tileEntity instanceof BlockEntityDamTurbine;
    }

    public String getRotationText() {
        return "Rot: " + (int)this.rotation + " rpm";
    }

    public float getRotationFill() {
        return this.getNormalizedRotation() * 180.0f;
    }

    private float getNormalizedRotation() {
        return Utils.normalizeClamped(this.rotation, 0.0f, MAX_PROCESSING);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        BlockEntityDamTurbine master = (BlockEntityDamTurbine)((Object)this.getMaster());
        if (master == null || side == null) {
            return super.getCapability(cap, side);
        }
        Direction masterFace = this.getMasterFacing();
        if (cap == ForgeCapabilities.FLUID_HANDLER && this.f_58858_.equals((Object)master.m_58899_().m_121945_(masterFace).m_121945_(masterFace.m_122427_())) && side == masterFace) {
            return ((BlockEntityDamTurbine)((Object)this.getMaster())).inTankHandler.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && this.f_58858_.equals((Object)master.m_58899_().m_121945_(masterFace.m_122428_()).m_121945_(masterFace.m_122424_()).m_7495_()) && side == masterFace.m_122428_()) {
            return ((BlockEntityDamTurbine)((Object)this.getMaster())).dummyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        compoundTag.m_128350_("rotation", this.rotation);
        super.m_183515_(compoundTag);
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        this.rotation = compoundTag.m_128457_("rotation");
        super.m_142466_(compoundTag);
    }
}

