/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity.transport;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.block.abstracts.BlockPipeSwitchBase;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntitySyncable;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.init.ModBlocks;
import net.cassiokf.industrialrenewal.util.capability.CustomFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockEntityFluidValve
extends BlockEntitySyncable {
    private final CustomFluidTank dummyTank = new CustomFluidTank(0);
    private final CustomFluidTank fluidTank = new CustomFluidTank(10000){

        @Override
        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty() || !BlockEntityFluidValve.this.isOpen()) {
                return 0;
            }
            IFluidHandler out = BlockEntityFluidValve.this.getOutput();
            if (out != null) {
                return out.fill(resource, action);
            }
            return 0;
        }

        @Override
        public boolean canFill() {
            return BlockEntityFluidValve.this.isOpen();
        }

        @Override
        public boolean canDrain() {
            return false;
        }
    };
    private final LazyOptional<CustomFluidTank> tankLazyOptional = LazyOptional.of(() -> this.fluidTank);
    private final LazyOptional<CustomFluidTank> dummyLazyOptional = LazyOptional.of(() -> this.dummyTank);

    public BlockEntityFluidValve(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.FLUID_VALVE_TILE.get(), pos, state);
    }

    private IFluidHandler getOutput() {
        if (this.f_58857_ == null) {
            return null;
        }
        Direction facing = this.getFacing();
        BlockEntity outputTile = this.f_58857_.m_7702_(this.f_58858_.m_121945_(facing));
        if (outputTile != null) {
            return (IFluidHandler)outputTile.getCapability(ForgeCapabilities.FLUID_HANDLER, facing.m_122424_()).orElse(null);
        }
        return null;
    }

    private boolean isOpen() {
        return this.m_58900_().m_60713_((Block)ModBlocks.FLUID_VALVE.get()) ? (Boolean)this.m_58900_().m_61143_((Property)BlockPipeSwitchBase.ON_OFF) : false;
    }

    private Direction getFacing() {
        return this.m_58900_().m_60713_((Block)ModBlocks.FLUID_VALVE.get()) ? (Direction)this.m_58900_().m_61143_((Property)BlockPipeSwitchBase.FACING) : Direction.NORTH;
    }

    public void invalidateCaps() {
        this.tankLazyOptional.invalidate();
        this.dummyLazyOptional.invalidate();
        super.invalidateCaps();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        Direction facing = this.getFacing();
        if (side == null) {
            return super.getCapability(cap, side);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (side == facing.m_122424_()) {
                return this.tankLazyOptional.cast();
            }
            if (side == facing) {
                return this.dummyLazyOptional.cast();
            }
        }
        return super.getCapability(cap, side);
    }
}

