/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.data;

import java.util.concurrent.CompletableFuture;
import net.cassiokf.industrialrenewal.data.client.ModBlockStateProvider;
import net.cassiokf.industrialrenewal.data.client.ModBlockTagGenerator;
import net.cassiokf.industrialrenewal.data.client.ModItemModelProvider;
import net.cassiokf.industrialrenewal.data.client.ModItemTagGenerator;
import net.cassiokf.industrialrenewal.data.client.ModLootTableProvider;
import net.cassiokf.industrialrenewal.data.client.ModRecipeProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="industrialrenewal", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    private DataGenerators() {
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        gen.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput));
        gen.addProvider(event.includeServer(), (DataProvider)ModLootTableProvider.create(packOutput));
        gen.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        ModBlockTagGenerator blockTagGenerator = (ModBlockTagGenerator)gen.addProvider(event.includeServer(), (DataProvider)new ModBlockTagGenerator(packOutput, lookupProvider, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModItemTagGenerator(packOutput, lookupProvider, blockTagGenerator.m_274426_(), existingFileHelper));
    }
}

