/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.obj;

import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntitySyncable;
import net.cassiokf.industrialrenewal.init.ModFluids;
import net.cassiokf.industrialrenewal.util.Utils;
import net.cassiokf.industrialrenewal.util.capability.CustomFluidTank;
import net.cassiokf.industrialrenewal.util.capability.CustomItemStackHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class SteamBoiler {
    public static final String steamName = "Steam";
    public static final FluidStack steamStack = new FluidStack((Fluid)ModFluids.STEAM.get(), 1000);
    private static final int maxHeat = 32000;
    private static final int waterPtick = 76;
    private final BlockEntitySyncable tiedTE;
    private final CustomFluidTank waterTank = new CustomFluidTank(32000){

        public boolean isFluidValid(FluidStack stack) {
            return stack != null;
        }

        @Override
        public boolean canDrain() {
            return false;
        }

        public void onContentsChanged() {
            SteamBoiler.this.tiedTE.sync();
        }
    };
    private final CustomFluidTank steamTank = new CustomFluidTank(320000){

        @Override
        public boolean canFill() {
            return false;
        }

        @Override
        public boolean canDrain() {
            return false;
        }

        public void onContentsChanged() {
            SteamBoiler.this.tiedTE.sync();
        }
    };
    private boolean useSolid;
    private int amountPerTick;
    private int heat;
    private int oldHeat;
    private int fuelTime;
    private String fuelName = "";
    private int maxFuelTime;
    private final CustomFluidTank fuelTank = new CustomFluidTank(32000){

        public boolean isFluidValid(FluidStack stack) {
            return stack != null;
        }

        @Override
        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return SteamBoiler.this.updateLiquidFuel(resource, action);
        }
    };
    public LazyOptional<IItemHandler> solidFuelInv = LazyOptional.of(this::createFuelInv);
    private int steamGenerated;
    private int oldFuelTime;

    public SteamBoiler(BlockEntitySyncable tiedTE, BoilerType useSolid, int amountPerTick) {
        this.tiedTE = tiedTE;
        this.useSolid = useSolid == BoilerType.Solid;
        this.amountPerTick = amountPerTick;
    }

    private IItemHandler createFuelInv() {
        return new CustomItemStackHandler(1){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (stack.m_41619_()) {
                    return false;
                }
                return FurnaceBlockEntity.m_58399_((ItemStack)stack);
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return SteamBoiler.this.updateSolidFuel(stack, simulate);
            }
        }.setBlockEntity(this.tiedTE);
    }

    public boolean canRun() {
        return this.fuelTime >= this.amountPerTick && !this.waterTank.isEmpty();
    }

    public SteamBoiler setWaterTankCapacity(int amount) {
        this.waterTank.setCapacity(amount);
        return this;
    }

    public void onTick() {
        if (this.tiedTE.m_58904_().m_5776_()) {
            return;
        }
        this.updateHeat();
        this.generateSteam();
        this.heat = Mth.m_14045_((int)this.heat, (int)2420, (int)32000);
        this.fuelTime = Math.max(0, this.fuelTime);
        this.outPutSteam();
        if (this.steamTank.getFluidAmount() > 0 && this.heat < 9000) {
            this.steamTank.drainInternal(10, IFluidHandler.FluidAction.EXECUTE);
        }
        if (this.oldHeat != this.heat || this.fuelTime != this.oldFuelTime) {
            this.oldHeat = this.heat;
            this.oldFuelTime = this.fuelTime;
            this.tiedTE.sync();
        }
    }

    public CustomFluidTank getFuelTank() {
        return this.fuelTank;
    }

    public CustomFluidTank getSteamTank() {
        return this.steamTank;
    }

    public CustomFluidTank getWaterTank() {
        return this.waterTank;
    }

    public LazyOptional<IItemHandler> getSolidFuelInvHandler() {
        return this.solidFuelInv;
    }

    public CustomItemStackHandler getSolidFuelInv() {
        return (CustomItemStackHandler)((Object)this.solidFuelInv.orElse(null));
    }

    private void generateSteam() {
        if (this.heat >= 10000 && this.waterTank.getFluidAmount() >= 76 && this.steamTank.getFluidAmount() < this.steamTank.getCapacity()) {
            float factor = Utils.normalizeClamped(this.heat, 10000.0f, 32000.0f);
            int amount = Math.round(76.0f * factor);
            this.waterTank.drainInternal(amount, IFluidHandler.FluidAction.EXECUTE);
            steamStack.setAmount(amount * 5);
            this.steamGenerated = this.steamTank.fillInternal(steamStack, IFluidHandler.FluidAction.EXECUTE);
            this.heat -= 4;
        } else {
            this.steamGenerated = 0;
            this.heat -= 2;
        }
    }

    public void outPutSteam() {
        IFluidHandler upTank;
        if (this.tiedTE.m_58904_().m_5776_() || this.steamTank.getFluidAmount() <= 0) {
            return;
        }
        BlockPos pos = this.tiedTE.m_58899_().m_6630_(2);
        BlockEntity tileEntity = this.tiedTE.m_58904_().m_7702_(pos);
        if (tileEntity != null && tileEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.DOWN).isPresent() && (upTank = (IFluidHandler)tileEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.DOWN).orElse(null)) != null) {
            this.steamTank.drainInternal(upTank.fill(this.steamTank.drainInternal(10000, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void setType(BoilerType type, int amountPerTick) {
        switch (type) {
            case Solid: {
                this.useSolid = true;
                break;
            }
            case Liquid: {
                this.useSolid = false;
            }
        }
        this.amountPerTick = amountPerTick;
        this.resetFuelTime();
    }

    public int getFuelTime() {
        return this.fuelTime;
    }

    public int getMaxFuelTime() {
        return this.maxFuelTime;
    }

    public String getFuelName() {
        return this.fuelName;
    }

    public int getHeat() {
        return this.heat;
    }

    public int getMaxHeat() {
        return 32000;
    }

    public int getWaterTankAmount() {
        return this.waterTank.getFluidAmount();
    }

    public void dropItemsOnGround(BlockPos pos) {
        Utils.dropInventoryItems(this.tiedTE.m_58904_(), pos, (ItemStackHandler)this.getSolidFuelInv());
    }

    private ItemStack updateSolidFuel(ItemStack stack, boolean simulate) {
        if (!this.useSolid || this.fuelTime >= this.amountPerTick) {
            return stack;
        }
        int fuel = ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44109_);
        if (fuel > 0) {
            if (!simulate) {
                this.maxFuelTime = this.fuelTime = fuel;
                this.fuelName = stack.m_41611_().getString();
                stack.m_41774_(1);
            }
            ItemStack stack1 = stack.m_41777_();
            stack1.m_41774_(1);
            return simulate ? stack1 : stack;
        }
        return stack;
    }

    private void updateHeat() {
        if (this.fuelTime >= this.amountPerTick) {
            this.heat += 8;
            this.fuelTime -= this.amountPerTick;
        } else if (this.fuelTime > 0) {
            this.resetFuelTime();
        } else {
            this.heat -= 2;
        }
    }

    public void coolDown() {
        if (this.tiedTE.m_58904_().m_5776_()) {
            return;
        }
        if (this.steamTank.getFluidAmount() > 0 && this.heat < 9000) {
            this.steamTank.drainInternal(10, IFluidHandler.FluidAction.EXECUTE);
        }
        if (this.heat > 2420) {
            this.heat -= 6;
            this.tiedTE.sync();
        }
    }

    private int updateLiquidFuel(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.useSolid) {
            return 0;
        }
        if (this.fuelTime > 0) {
            return 0;
        }
        int fuel = 1000;
        if (fuel > 0) {
            int amount = Math.min(1000, resource.getAmount());
            float norm = Utils.normalizeClamped(amount, 0.0f, 1000.0f);
            if (action.equals((Object)IFluidHandler.FluidAction.EXECUTE)) {
                this.maxFuelTime = this.fuelTime = (int)((float)fuel * norm);
                this.fuelName = resource.getDisplayName().getString();
            }
            return amount;
        }
        return 0;
    }

    public void resetFuelTime() {
        this.fuelTime = 0;
    }

    public void saveBoiler(CompoundTag compound) {
        CompoundTag newTag = new CompoundTag();
        newTag.m_128405_("fuelTime", this.fuelTime);
        newTag.m_128405_("maxFuelTime", this.maxFuelTime);
        newTag.m_128405_("amountPerTick", this.amountPerTick);
        newTag.m_128405_("heat", this.heat);
        newTag.m_128405_("steamGen", this.steamGenerated);
        newTag.m_128379_("useSolid", this.useSolid);
        newTag.m_128359_("fuelName", this.fuelName);
        newTag.m_128365_("steam", (Tag)this.steamTank.writeToNBT(new CompoundTag()));
        newTag.m_128365_("water", (Tag)this.waterTank.writeToNBT(new CompoundTag()));
        compound.m_128365_("boiler", (Tag)newTag);
    }

    public void loadBoiler(CompoundTag compound) {
        CompoundTag nbt = compound.m_128469_("boiler");
        this.fuelTime = nbt.m_128451_("fuelTime");
        this.maxFuelTime = nbt.m_128451_("maxFuelTime");
        this.amountPerTick = nbt.m_128451_("amountPerTick");
        this.heat = nbt.m_128451_("heat");
        this.steamGenerated = nbt.m_128451_("steamGen");
        this.useSolid = nbt.m_128471_("useSolid");
        this.fuelName = nbt.m_128461_("fuelName");
        this.steamTank.readFromNBT(nbt.m_128469_("steam"));
        this.waterTank.readFromNBT(nbt.m_128469_("water"));
    }

    public boolean isBurning() {
        return this.fuelTime > 0;
    }

    public String getWaterText() {
        return "Water";
    }

    public String getSteamText() {
        return steamName;
    }

    public String getFuelText() {
        if (this.useSolid) {
            IItemHandler handler = (IItemHandler)this.solidFuelInv.orElse(null);
            if (this.solidFuelInv.isPresent()) {
                int energy = handler.getStackInSlot(0).m_41613_();
                return energy == 0 ? "No Fuel" : energy + " Fuel";
            }
        }
        return this.fuelTank.getFluidAmount() > 0 ? this.fuelTank.getFluid().getDisplayName().getString() : "No Fuel";
    }

    public String getHeatText() {
        return (int)Utils.getConvertedTemperature((float)this.heat / 100.0f) + " " + Utils.getTemperatureUnit();
    }

    public float getFuelFill() {
        return Utils.normalizeClamped(this.fuelTime, 0.0f, this.maxFuelTime) * 180.0f;
    }

    public float GetWaterFill() {
        return Utils.normalizeClamped(this.waterTank.getFluidAmount(), 0.0f, this.waterTank.getCapacity()) * 180.0f;
    }

    public float GetSteamFill() {
        if (this.steamGenerated == 0 && this.steamTank.getFluidAmount() == 0) {
            return 0.0f;
        }
        return 45.0f + Utils.normalizeClamped(this.steamTank.getFluidAmount(), 0.0f, this.steamTank.getCapacity()) * 135.0f;
    }

    public float getHeatFill() {
        return Utils.normalizeClamped(this.getHeat(), 0.0f, this.getMaxHeat()) * 140.0f;
    }

    public static enum BoilerType {
        Solid,
        Liquid;

    }
}

