/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.util.capability;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntitySyncable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class CustomFluidTank
extends FluidTank {
    public BlockEntitySyncable blockEntity;
    private boolean canFill = true;
    private boolean canDrain = true;

    public CustomFluidTank(int capacity) {
        super(capacity);
    }

    public CustomFluidTank(int capacity, Predicate<FluidStack> validator) {
        super(capacity, validator);
    }

    public void onFluidChange() {
        if (this.blockEntity != null) {
            this.blockEntity.sync();
        }
    }

    public CustomFluidTank setBlockEntity(BlockEntitySyncable entity) {
        this.blockEntity = entity;
        return this;
    }

    public int fillInternal(FluidStack resource, IFluidHandler.FluidAction action) {
        this.onFluidChange();
        return super.fill(resource, action);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        this.onFluidChange();
        return this.canFill() ? super.fill(resource, action) : 0;
    }

    public FluidStack drainInternal(int maxDrain, IFluidHandler.FluidAction action) {
        this.onFluidChange();
        return super.drain(maxDrain, action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        this.onFluidChange();
        return this.canDrain() ? super.drain(maxDrain, action) : super.drain(0, action);
    }

    public CustomFluidTank noDrain() {
        this.canDrain = false;
        return this;
    }

    public CustomFluidTank noFill() {
        this.canFill = false;
        return this;
    }

    public boolean canFill() {
        return this.canFill;
    }

    public boolean canDrain() {
        return this.canDrain;
    }
}

